/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.audit.AuditService;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.MemberResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class DeleteMembers
implements RestModifyView<GroupResource, AddMembers.Input> {
    private final AccountsCollection accounts;
    private final AccountCache accountCache;
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> self;
    private final AuditService auditService;

    @Inject
    DeleteMembers(AccountsCollection accounts, AccountCache accountCache, Provider<ReviewDb> db, Provider<CurrentUser> self, AuditService auditService) {
        this.accounts = accounts;
        this.accountCache = accountCache;
        this.db = db;
        this.self = self;
        this.auditService = auditService;
    }

    public Response<?> apply(GroupResource resource, AddMembers.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException {
        AccountGroup internalGroup = resource.toAccountGroup();
        if (internalGroup == null) {
            throw new MethodNotAllowedException();
        }
        input = AddMembers.Input.init(input);
        GroupControl control = resource.getControl();
        Map<Account.Id, AccountGroupMember> members = this.getMembers(internalGroup.getId());
        ArrayList<AccountGroupMember> toRemove = new ArrayList<AccountGroupMember>();
        for (String nameOrEmail : input.members) {
            Account a = this.accounts.parse(nameOrEmail).getAccount();
            if (!control.canRemoveMember()) {
                throw new AuthException("Cannot delete member: " + a.getFullName());
            }
            AccountGroupMember m = members.remove(a.getId());
            if (m == null) continue;
            toRemove.add(m);
        }
        this.writeAudits(toRemove);
        this.db.get().accountGroupMembers().delete(toRemove);
        for (AccountGroupMember m : toRemove) {
            this.accountCache.evict(m.getAccountId());
        }
        return Response.none();
    }

    private void writeAudits(List<AccountGroupMember> toRemove) {
        Account.Id me = this.self.get().getAccountId();
        this.auditService.dispatchDeleteAccountsFromGroup(me, toRemove);
    }

    private Map<Account.Id, AccountGroupMember> getMembers(AccountGroup.Id groupId) throws OrmException {
        HashMap<Account.Id, AccountGroupMember> members = new HashMap<Account.Id, AccountGroupMember>();
        for (AccountGroupMember m : this.db.get().accountGroupMembers().byGroup(groupId)) {
            members.put(m.getAccountId(), m);
        }
        return members;
    }

    @Singleton
    static class DeleteMember
    implements RestModifyView<MemberResource, Input> {
        private final Provider<DeleteMembers> delete;

        @Inject
        DeleteMember(Provider<DeleteMembers> delete) {
            this.delete = delete;
        }

        public Response<?> apply(MemberResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException {
            AddMembers.Input in = new AddMembers.Input();
            in._oneMember = resource.getMember().getAccountId().toString();
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

