/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collections;

@Singleton
public class PutOwner
implements RestModifyView<GroupResource, Input> {
    private final GroupsCollection groupsCollection;
    private final GroupCache groupCache;
    private final Provider<ReviewDb> db;
    private final GroupJson json;

    @Inject
    PutOwner(GroupsCollection groupsCollection, GroupCache groupCache, Provider<ReviewDb> db, GroupJson json) {
        this.groupsCollection = groupsCollection;
        this.groupCache = groupCache;
        this.db = db;
        this.json = json;
    }

    public GroupInfo apply(GroupResource resource, Input input) throws ResourceNotFoundException, MethodNotAllowedException, AuthException, BadRequestException, UnprocessableEntityException, OrmException, IOException {
        AccountGroup group = resource.toAccountGroup();
        if (group == null) {
            throw new MethodNotAllowedException();
        }
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.owner)) {
            throw new BadRequestException("owner is required");
        }
        group = this.db.get().accountGroups().get(group.getId());
        if (group == null) {
            throw new ResourceNotFoundException();
        }
        GroupDescription.Basic owner = this.groupsCollection.parse(input.owner);
        if (!group.getOwnerGroupUUID().equals(owner.getGroupUUID())) {
            group.setOwnerGroupUUID(owner.getGroupUUID());
            this.db.get().accountGroups().update(Collections.singleton(group));
            this.groupCache.evict(group);
        }
        return this.json.format(owner);
    }

    public static class Input {
        @DefaultInput
        public String owner;
    }
}

