/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.IndexCollection;
import com.google.gerrit.server.index.IndexDefinition;
import com.google.gerrit.server.index.SiteIndexer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineReindexer<K, V, I extends Index<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(OnlineReindexer.class);
    private final IndexCollection<K, V, I> indexes;
    private final SiteIndexer<K, V, I> batchIndexer;
    private final int version;
    private I index;
    private final AtomicBoolean running = new AtomicBoolean();

    public OnlineReindexer(IndexDefinition<K, V, I> def, int version) {
        this.indexes = def.getIndexCollection();
        this.batchIndexer = def.getSiteIndexer();
        this.version = version;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        OnlineReindexer.this.reindex();
                    }
                    finally {
                        OnlineReindexer.this.running.set(false);
                    }
                }
            };
            t.setName(String.format("Reindex v%d-v%d", OnlineReindexer.version(this.indexes.getSearchIndex()), this.version));
            t.start();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getVersion() {
        return this.version;
    }

    private static int version(Index<?, ?> i) {
        return i.getSchema().getVersion();
    }

    private void reindex() {
        this.index = (Index)Preconditions.checkNotNull(this.indexes.getWriteIndex(this.version), "not an active write schema version: %s", this.version);
        log.info("Starting online reindex from schema version {} to {}", (Object)OnlineReindexer.version(this.indexes.getSearchIndex()), (Object)OnlineReindexer.version(this.index));
        SiteIndexer.Result result = this.batchIndexer.indexAll(this.index);
        if (!result.success()) {
            log.error("Online reindex of schema version {} failed. Successfully indexed {} changes, failed to index {} changes", OnlineReindexer.version(this.index), result.doneCount(), result.failedCount());
            return;
        }
        log.info("Reindex to version {} complete", (Object)OnlineReindexer.version(this.index));
        this.activateIndex();
    }

    public void activateIndex() {
        this.indexes.setSearchIndex(this.index);
        log.info("Using schema version {}", (Object)OnlineReindexer.version(this.index));
        try {
            this.index.markReady(true);
        }
        catch (IOException e) {
            log.warn("Error activating new schema version {}", (Object)OnlineReindexer.version(this.index));
        }
        ArrayList<Index> toRemove = Lists.newArrayListWithExpectedSize(1);
        for (Index i : this.indexes.getWriteIndexes()) {
            if (OnlineReindexer.version(i) == OnlineReindexer.version(this.index)) continue;
            toRemove.add(i);
        }
        for (Index i : toRemove) {
            try {
                i.markReady(false);
                this.indexes.removeWriteIndex(OnlineReindexer.version(i));
            }
            catch (IOException e) {
                log.warn("Error deactivating old schema version {}", (Object)OnlineReindexer.version(i));
            }
        }
    }
}

