/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.group;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.SiteIndexer;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AllGroupsIndexer
extends SiteIndexer<AccountGroup.UUID, AccountGroup, GroupIndex> {
    private static final Logger log = LoggerFactory.getLogger(AllGroupsIndexer.class);
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ListeningExecutorService executor;
    private final GroupCache groupCache;

    @Inject
    AllGroupsIndexer(SchemaFactory<ReviewDb> schemaFactory, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor, GroupCache groupCache) {
        this.schemaFactory = schemaFactory;
        this.executor = executor;
        this.groupCache = groupCache;
    }

    @Override
    public SiteIndexer.Result indexAll(GroupIndex index) {
        List<AccountGroup.UUID> uuids;
        TextProgressMonitor progress = new TextProgressMonitor(this.newPrintWriter(this.progressOut));
        progress.start(2);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            uuids = this.collectGroups(progress);
        }
        catch (OrmException e) {
            log.error("Error collecting groups", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        return this.reindexGroups(index, uuids, progress);
    }

    private SiteIndexer.Result reindexGroups(final GroupIndex index, List<AccountGroup.UUID> uuids, ProgressMonitor progress) {
        progress.beginTask("Reindexing groups", uuids.size());
        ArrayList<Future> futures = new ArrayList<Future>(uuids.size());
        AtomicBoolean ok = new AtomicBoolean(true);
        final AtomicInteger done = new AtomicInteger();
        final AtomicInteger failed = new AtomicInteger();
        Stopwatch sw = Stopwatch.createStarted();
        for (final AccountGroup.UUID uuid : uuids) {
            final String desc = "group " + uuid;
            Future future = this.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        AccountGroup oldGroup = AllGroupsIndexer.this.groupCache.get(uuid);
                        if (oldGroup != null) {
                            AllGroupsIndexer.this.groupCache.evict(oldGroup);
                        }
                        index.replace(AllGroupsIndexer.this.groupCache.get(uuid));
                        AllGroupsIndexer.this.verboseWriter.println("Reindexed " + desc);
                        done.incrementAndGet();
                    }
                    catch (Exception e) {
                        failed.incrementAndGet();
                        throw e;
                    }
                    return null;
                }
            });
            this.addErrorListener((ListenableFuture<?>)future, desc, progress, ok);
            futures.add(future);
        }
        try {
            Futures.successfulAsList(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Error waiting on group futures", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        progress.endTask();
        return new SiteIndexer.Result(sw, ok.get(), done.get(), failed.get());
    }

    private List<AccountGroup.UUID> collectGroups(ProgressMonitor progress) throws OrmException {
        progress.beginTask("Collecting groups", 0);
        ArrayList<AccountGroup.UUID> uuids = new ArrayList<AccountGroup.UUID>();
        try (ReviewDb db = this.schemaFactory.open();){
            for (AccountGroup group : db.accountGroups().all()) {
                uuids.add(group.getGroupUUID());
            }
        }
        progress.endTask();
        return uuids;
    }
}

