/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.group;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.events.GroupIndexedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.index.Index;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.GroupIndexer;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class GroupIndexerImpl
implements GroupIndexer {
    private final GroupCache groupCache;
    private final DynamicSet<GroupIndexedListener> indexedListener;
    private final GroupIndexCollection indexes;
    private final GroupIndex index;

    @AssistedInject
    GroupIndexerImpl(GroupCache groupCache, DynamicSet<GroupIndexedListener> indexedListener, @Assisted GroupIndexCollection indexes) {
        this.groupCache = groupCache;
        this.indexedListener = indexedListener;
        this.indexes = indexes;
        this.index = null;
    }

    @AssistedInject
    GroupIndexerImpl(GroupCache groupCache, DynamicSet<GroupIndexedListener> indexedListener, @Assisted GroupIndex index) {
        this.groupCache = groupCache;
        this.indexedListener = indexedListener;
        this.indexes = null;
        this.index = index;
    }

    @Override
    public void index(AccountGroup.UUID uuid) throws IOException {
        for (Index index : this.getWriteIndexes()) {
            index.replace(this.groupCache.get(uuid));
        }
        this.fireGroupIndexedEvent(uuid.get());
    }

    private void fireGroupIndexedEvent(String uuid) {
        for (GroupIndexedListener listener : this.indexedListener) {
            listener.onGroupIndexed(uuid);
        }
    }

    private Collection<GroupIndex> getWriteIndexes() {
        if (this.indexes != null) {
            return this.indexes.getWriteIndexes();
        }
        return this.index != null ? Collections.singleton(this.index) : ImmutableSet.of();
    }

    public static interface Factory {
        public GroupIndexerImpl create(GroupIndexCollection var1);

        public GroupIndexerImpl create(@Nullable GroupIndex var1);
    }
}

