/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AuthRequest;

public interface EmailTokenVerifier {
    public String encode(Account.Id var1, String var2);

    public ParsedToken decode(String var1) throws InvalidTokenException;

    public static class ParsedToken {
        private final Account.Id accountId;
        private final String emailAddress;

        public ParsedToken(Account.Id accountId, String emailAddress) {
            this.accountId = accountId;
            this.emailAddress = emailAddress;
        }

        public Account.Id getAccountId() {
            return this.accountId;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public AuthRequest toAuthRequest() {
            return AuthRequest.forEmail(this.getEmailAddress());
        }

        public String toString() {
            return this.accountId + " adds " + this.emailAddress;
        }
    }

    public static class InvalidTokenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidTokenException() {
            super("Invalid token");
        }

        public InvalidTokenException(Throwable cause) {
            super("Invalid token", cause);
        }
    }
}

