/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.MetadataName;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailMetadata;
import com.google.gerrit.server.mail.receive.MailProcessor;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataParser {
    private static final Logger log = LoggerFactory.getLogger(MailProcessor.class);

    public static MailMetadata parse(MailMessage m) {
        String[] lines;
        MailMetadata metadata = new MailMetadata();
        metadata.author = m.from().getEmail();
        for (String header : m.additionalHeaders()) {
            if (header.startsWith(MetadataName.toHeaderWithDelimiter("Gerrit-Change-Number"))) {
                String num = header.substring(MetadataName.toHeaderWithDelimiter("Gerrit-Change-Number").length());
                metadata.changeNumber = Ints.tryParse(num);
                continue;
            }
            if (header.startsWith(MetadataName.toHeaderWithDelimiter("Gerrit-PatchSet"))) {
                String ps = header.substring(MetadataName.toHeaderWithDelimiter("Gerrit-PatchSet").length());
                metadata.patchSet = Ints.tryParse(ps);
                continue;
            }
            if (header.startsWith(MetadataName.toHeaderWithDelimiter("Gerrit-Comment-Date"))) {
                String ts = header.substring(MetadataName.toHeaderWithDelimiter("Gerrit-Comment-Date").length()).trim();
                try {
                    metadata.timestamp = Timestamp.from(MailUtil.rfcDateformatter.parse((CharSequence)ts, Instant::from));
                }
                catch (DateTimeParseException e) {
                    log.error("Mail: Error while parsing timestamp from header of message " + m.id(), e);
                }
                continue;
            }
            if (!header.startsWith(MetadataName.toHeaderWithDelimiter("Gerrit-MessageType"))) continue;
            metadata.messageType = header.substring(MetadataName.toHeaderWithDelimiter("Gerrit-MessageType").length());
        }
        if (metadata.hasRequiredFields()) {
            return metadata;
        }
        if (!Strings.isNullOrEmpty(m.textContent())) {
            lines = m.textContent().replace("\r\n", "\n").split("\n");
            MetadataParser.extractFooters(lines, metadata, m);
            if (metadata.hasRequiredFields()) {
                return metadata;
            }
        }
        if (!Strings.isNullOrEmpty(m.htmlContent())) {
            lines = m.htmlContent().replace("\r\n", "\n").split("</div>");
            MetadataParser.extractFooters(lines, metadata, m);
            if (metadata.hasRequiredFields()) {
                return metadata;
            }
        }
        return metadata;
    }

    private static void extractFooters(String[] lines, MailMetadata metadata, MailMessage m) {
        for (String line : lines) {
            if (metadata.changeNumber == null && line.contains("Gerrit-Change-Number")) {
                metadata.changeNumber = Ints.tryParse(MetadataParser.extractFooter(MetadataName.toFooterWithDelimiter("Gerrit-Change-Number"), line));
                continue;
            }
            if (metadata.patchSet == null && line.contains("Gerrit-PatchSet")) {
                metadata.patchSet = Ints.tryParse(MetadataParser.extractFooter(MetadataName.toFooterWithDelimiter("Gerrit-PatchSet"), line));
                continue;
            }
            if (metadata.timestamp == null && line.contains("Gerrit-Comment-Date")) {
                String ts = MetadataParser.extractFooter(MetadataName.toFooterWithDelimiter("Gerrit-Comment-Date"), line);
                try {
                    metadata.timestamp = Timestamp.from(MailUtil.rfcDateformatter.parse((CharSequence)ts, Instant::from));
                }
                catch (DateTimeParseException e) {
                    log.error("Mail: Error while parsing timestamp from footer of message " + m.id(), e);
                }
                continue;
            }
            if (metadata.messageType != null || !line.contains("Gerrit-MessageType")) continue;
            metadata.messageType = MetadataParser.extractFooter(MetadataName.toFooterWithDelimiter("Gerrit-MessageType"), line);
        }
    }

    private static String extractFooter(String key, String line) {
        return line.substring(line.indexOf(key) + key.length(), line.length()).trim();
    }
}

