/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import com.google.common.primitives.Ints;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailParsingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.joda.time.DateTime;

public class RawMailParser {
    private static final ImmutableSet<String> MAIN_HEADERS = ImmutableSet.of("to", "from", "cc", "date", "message-id", "subject", new String[]{"content-type"});

    public static MailMessage parse(String raw) throws MailParsingException {
        Message mimeMessage;
        MailMessage.Builder messageBuilder = MailMessage.builder();
        messageBuilder.rawContentUTF(raw);
        try {
            DefaultMessageBuilder builder = new DefaultMessageBuilder();
            mimeMessage = builder.parseMessage(new ByteArrayInputStream(raw.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException | MimeException e) {
            throw new MailParsingException("Can't parse email", e);
        }
        if (mimeMessage.getMessageId() != null) {
            messageBuilder.id(mimeMessage.getMessageId());
        }
        if (mimeMessage.getSubject() != null) {
            messageBuilder.subject(mimeMessage.getSubject());
        }
        messageBuilder.dateReceived(new DateTime(mimeMessage.getDate()));
        if (mimeMessage.getFrom() != null && mimeMessage.getFrom().size() > 0) {
            Iterator from = mimeMessage.getFrom().get(0);
            messageBuilder.from(new Address(((Mailbox)((Object)from)).getName(), ((Mailbox)((Object)from)).getAddress()));
        }
        if (mimeMessage.getTo() != null) {
            for (Mailbox m : mimeMessage.getTo().flatten()) {
                messageBuilder.addTo(new Address(m.getName(), m.getAddress()));
            }
        }
        if (mimeMessage.getCc() != null) {
            for (Mailbox m : mimeMessage.getCc().flatten()) {
                messageBuilder.addCc(new Address(m.getName(), m.getAddress()));
            }
        }
        mimeMessage.getHeader().getFields().stream().filter(f -> !MAIN_HEADERS.contains(f.getName().toLowerCase())).forEach(f -> messageBuilder.addAdditionalHeader(f.getName() + ": " + f.getBody()));
        StringBuilder textBuilder = new StringBuilder();
        StringBuilder htmlBuilder = new StringBuilder();
        try {
            RawMailParser.handleMimePart(mimeMessage, textBuilder, htmlBuilder);
        }
        catch (IOException e) {
            throw new MailParsingException("Can't parse email", e);
        }
        messageBuilder.textContent(Strings.emptyToNull(textBuilder.toString()));
        messageBuilder.htmlContent(Strings.emptyToNull(htmlBuilder.toString()));
        try {
            return messageBuilder.build();
        }
        catch (IllegalStateException e) {
            throw new MailParsingException("Missing required attributes after email was parsed", e);
        }
    }

    public static MailMessage parse(int[] chars) throws MailParsingException {
        StringBuilder b = new StringBuilder(chars.length);
        for (int c : chars) {
            b.append((char)c);
        }
        MailMessage.Builder messageBuilder = RawMailParser.parse(b.toString()).toBuilder();
        messageBuilder.rawContent(ImmutableList.copyOf(Ints.asList(chars)));
        return messageBuilder.build();
    }

    private static void handleMimePart(Entity part, StringBuilder textBuilder, StringBuilder htmlBuilder) throws IOException {
        block4: {
            block2: {
                String result;
                block3: {
                    if (!RawMailParser.isPlainOrHtml(part.getMimeType()) || RawMailParser.isAttachment(part.getDispositionType())) break block2;
                    TextBody tb = (TextBody)part.getBody();
                    result = CharStreams.toString(new InputStreamReader(tb.getInputStream(), tb.getMimeCharset()));
                    if (!part.getMimeType().equals("text/plain")) break block3;
                    textBuilder.append(result);
                    break block4;
                }
                if (!part.getMimeType().equals("text/html")) break block4;
                htmlBuilder.append(result);
                break block4;
            }
            if (RawMailParser.isMultipart(part.getMimeType())) {
                Multipart multipart = (Multipart)part.getBody();
                for (Entity e : multipart.getBodyParts()) {
                    RawMailParser.handleMimePart(e, textBuilder, htmlBuilder);
                }
            }
        }
    }

    private static boolean isPlainOrHtml(String mimeType) {
        return mimeType.equals("text/plain") || mimeType.equals("text/html");
    }

    private static boolean isMultipart(String mimeType) {
        return mimeType.startsWith("multipart/");
    }

    private static boolean isAttachment(String dispositionType) {
        return dispositionType != null && dispositionType.equals("attachment");
    }
}

