/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mime;

import com.google.common.collect.ImmutableMap;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileExtensionRegistry
extends MimeDetector {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileExtensionRegistry.class);
    private static final ImmutableMap<String, MimeType> TYPES;

    @Override
    public String getDescription() {
        return this.getClass().getName();
    }

    @Override
    protected Collection<MimeType> getMimeTypesFileName(String name) {
        MimeType type;
        int s = name.lastIndexOf(47);
        if (s >= 0) {
            name = name.substring(s + 1);
        }
        if ((type = TYPES.get(name)) != null) {
            return Collections.singletonList(type);
        }
        int d = name.lastIndexOf(46);
        if (0 < d && (type = TYPES.get(name.substring(d + 1))) != null) {
            return Collections.singletonList(type);
        }
        return Collections.emptyList();
    }

    @Override
    protected Collection<MimeType> getMimeTypesFile(File file) {
        return this.getMimeTypesFileName(file.getName());
    }

    @Override
    protected Collection<MimeType> getMimeTypesURL(URL url) {
        return this.getMimeTypesFileName(url.getPath());
    }

    @Override
    protected Collection<MimeType> getMimeTypesInputStream(InputStream arg0) {
        return Collections.emptyList();
    }

    @Override
    protected Collection<MimeType> getMimeTypesByteArray(byte[] arg0) {
        return Collections.emptyList();
    }

    static {
        Properties prop = new Properties();
        try {
            InputStream in = DefaultFileExtensionRegistry.class.getResourceAsStream("mime-types.properties");
            Object object = null;
            try {
                prop.load(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.warn("Cannot load mime-types.properties", e);
        }
        ImmutableMap.Builder<String, FileExtensionMimeType> b = ImmutableMap.builder();
        for (Map.Entry entry : prop.entrySet()) {
            FileExtensionMimeType type = new FileExtensionMimeType((String)entry.getValue());
            b.put((String)entry.getKey(), type);
            MimeUtil.addKnownMimeType(type);
        }
        TYPES = b.build();
    }

    private static final class FileExtensionMimeType
    extends MimeType {
        private static final long serialVersionUID = 1L;

        FileExtensionMimeType(String mimeType) throws MimeException {
            super(mimeType);
        }

        @Override
        public int getSpecificity() {
            return 2;
        }
    }
}

