/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import com.google.gerrit.server.git.RefCache;
import com.google.gerrit.server.git.RepoRefCache;
import com.google.gerrit.server.notedb.AbstractChangeNotes;
import com.google.gerrit.server.notedb.ChangeNotesCache;
import com.google.gerrit.server.notedb.ChangeNotesState;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.DraftCommentNotes;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.notedb.RobotCommentNotes;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeNotes
extends AbstractChangeNotes<ChangeNotes> {
    private static final Logger log = LoggerFactory.getLogger(ChangeNotes.class);
    static final Ordering<PatchSetApproval> PSA_BY_TIME = Ordering.from(Comparator.comparing(PatchSetApproval::getGranted));
    public static final Ordering<ChangeMessage> MESSAGE_BY_TIME = Ordering.from(Comparator.comparing(ChangeMessage::getWrittenOn));
    private final boolean shouldExist;
    private final RefCache refs;
    private Change change;
    private ChangeNotesState state;
    RevisionNoteMap<ChangeRevisionNote> revisionNoteMap;
    private NoteDbUpdateManager.Result rebuildResult;
    private DraftCommentNotes draftCommentNotes;
    private RobotCommentNotes robotCommentNotes;
    private ImmutableSortedMap<PatchSet.Id, PatchSet> patchSets;
    private ImmutableListMultimap<PatchSet.Id, PatchSetApproval> approvals;
    private ImmutableSet<Comment.Key> commentKeys;

    public static ConfigInvalidException parseException(Change.Id changeId, String fmt, Object ... args) {
        return new ConfigInvalidException("Change " + changeId + ": " + String.format(fmt, args));
    }

    public static Change readOneReviewDbChange(ReviewDb db, Change.Id id) throws OrmException {
        return ReviewDbUtil.unwrapDb(db).changes().get(id);
    }

    @VisibleForTesting
    public ChangeNotes(AbstractChangeNotes.Args args, Change change) {
        this(args, change, true, true, null);
    }

    private ChangeNotes(AbstractChangeNotes.Args args, Change change, boolean shouldExist, boolean autoRebuild, @Nullable RefCache refs) {
        super(args, change.getId(), NoteDbChangeState.PrimaryStorage.of(change), autoRebuild);
        this.change = new Change(change);
        this.shouldExist = shouldExist;
        this.refs = refs;
    }

    public Change getChange() {
        return this.change;
    }

    public ObjectId getMetaId() {
        return this.state.metaId();
    }

    public ImmutableSortedMap<PatchSet.Id, PatchSet> getPatchSets() {
        if (this.patchSets == null) {
            ImmutableSortedMap.Builder b = ImmutableSortedMap.orderedBy(Comparator.comparing(PatchSet.Id::get));
            for (Map.Entry entry : this.state.patchSets()) {
                b.put((PatchSet.Id)entry.getKey(), new PatchSet((PatchSet)entry.getValue()));
            }
            this.patchSets = b.build();
        }
        return this.patchSets;
    }

    public ImmutableListMultimap<PatchSet.Id, PatchSetApproval> getApprovals() {
        if (this.approvals == null) {
            ImmutableListMultimap.Builder b = ImmutableListMultimap.builder();
            for (Map.Entry entry : this.state.approvals()) {
                b.put((PatchSet.Id)entry.getKey(), new PatchSetApproval((PatchSetApproval)entry.getValue()));
            }
            this.approvals = b.build();
        }
        return this.approvals;
    }

    public ReviewerSet getReviewers() {
        return this.state.reviewers();
    }

    public ImmutableList<ReviewerStatusUpdate> getReviewerUpdates() {
        return this.state.reviewerUpdates();
    }

    public ImmutableSet<Account.Id> getPastAssignees() {
        return this.state.pastAssignees();
    }

    public ImmutableSet<String> getHashtags() {
        return ImmutableSortedSet.copyOf(this.state.hashtags());
    }

    public ImmutableList<Account.Id> getAllPastReviewers() {
        return this.state.allPastReviewers();
    }

    public ImmutableList<SubmitRecord> getSubmitRecords() {
        return this.state.submitRecords();
    }

    public ImmutableList<ChangeMessage> getChangeMessages() {
        return this.state.allChangeMessages();
    }

    public ImmutableListMultimap<PatchSet.Id, ChangeMessage> getChangeMessagesByPatchSet() {
        return this.state.changeMessagesByPatchSet();
    }

    public ImmutableListMultimap<RevId, Comment> getComments() {
        return this.state.publishedComments();
    }

    public ImmutableSet<Comment.Key> getCommentKeys() {
        if (this.commentKeys == null) {
            ImmutableSet.Builder b = ImmutableSet.builder();
            for (Comment c : this.getComments().values()) {
                b.add(new Comment.Key(c.key));
            }
            this.commentKeys = b.build();
        }
        return this.commentKeys;
    }

    public ImmutableListMultimap<RevId, Comment> getDraftComments(Account.Id author) throws OrmException {
        return this.getDraftComments(author, null);
    }

    public ImmutableListMultimap<RevId, Comment> getDraftComments(Account.Id author, @Nullable Ref ref) throws OrmException {
        this.loadDraftComments(author, ref);
        return ImmutableListMultimap.copyOf(Multimaps.filterEntries(this.draftCommentNotes.getComments(), e -> !this.getCommentKeys().contains(((Comment)e.getValue()).key)));
    }

    public ImmutableListMultimap<RevId, RobotComment> getRobotComments() throws OrmException {
        this.loadRobotComments();
        return this.robotCommentNotes.getComments();
    }

    private void loadDraftComments(Account.Id author, @Nullable Ref ref) throws OrmException {
        if (this.draftCommentNotes == null || !author.equals(this.draftCommentNotes.getAuthor()) || ref != null) {
            this.draftCommentNotes = new DraftCommentNotes(this.args, this.change, author, this.autoRebuild, this.rebuildResult, ref);
            this.draftCommentNotes.load();
        }
    }

    private void loadRobotComments() throws OrmException {
        if (this.robotCommentNotes == null) {
            this.robotCommentNotes = new RobotCommentNotes(this.args, this.change);
            this.robotCommentNotes.load();
        }
    }

    @VisibleForTesting
    DraftCommentNotes getDraftCommentNotes() {
        return this.draftCommentNotes;
    }

    public RobotCommentNotes getRobotCommentNotes() {
        return this.robotCommentNotes;
    }

    public boolean containsComment(Comment c) throws OrmException {
        if (this.containsCommentPublished(c)) {
            return true;
        }
        this.loadDraftComments(c.author.getId(), null);
        return this.draftCommentNotes.containsComment(c);
    }

    public boolean containsCommentPublished(Comment c) {
        for (Comment l : this.getComments().values()) {
            if (!c.key.equals(l.key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getRefName() {
        return RefNames.changeMetaRef(this.getChangeId());
    }

    public PatchSet getCurrentPatchSet() {
        PatchSet.Id psId = this.change.currentPatchSetId();
        return Preconditions.checkNotNull(this.getPatchSets().get(psId), "missing current patch set %s", psId.get());
    }

    @VisibleForTesting
    public Timestamp getReadOnlyUntil() {
        return this.state.readOnlyUntil();
    }

    @Override
    protected void onLoad(AbstractChangeNotes.LoadHandle handle) throws NoSuchChangeException, IOException, ConfigInvalidException {
        ObjectId rev = handle.id();
        if (rev == null) {
            if (this.args.migration.readChanges() && NoteDbChangeState.PrimaryStorage.of(this.change) == NoteDbChangeState.PrimaryStorage.NOTE_DB && this.shouldExist) {
                throw new NoSuchChangeException(this.getChangeId());
            }
            this.loadDefaults();
            return;
        }
        ChangeNotesCache.Value v = this.args.cache.get().get(this.getProjectName(), this.getChangeId(), rev, handle.walk());
        this.state = v.state();
        this.state.copyColumnsTo(this.change);
        this.revisionNoteMap = v.revisionNoteMap();
    }

    @Override
    protected void loadDefaults() {
        this.state = ChangeNotesState.empty(this.change);
    }

    @Override
    public Project.NameKey getProjectName() {
        return this.change.getProject();
    }

    @Override
    protected ObjectId readRef(Repository repo) throws IOException {
        return this.refs != null ? (ObjectId)this.refs.get(this.getRefName()).orElse(null) : super.readRef(repo);
    }

    @Override
    protected AbstractChangeNotes.LoadHandle openHandle(Repository repo) throws NoSuchChangeException, IOException {
        if (this.autoRebuild) {
            RefCache refs;
            NoteDbChangeState state = NoteDbChangeState.parse(this.change);
            ObjectId id = this.readRef(repo);
            if (id == null) {
                if (state == null) {
                    return super.openHandle(repo, id);
                }
                if (this.shouldExist) {
                    throw new NoSuchChangeException(this.getChangeId());
                }
            }
            RefCache refCache = refs = this.refs != null ? this.refs : new RepoRefCache(repo);
            if (!NoteDbChangeState.isChangeUpToDate(state, refs, this.getChangeId())) {
                return this.rebuildAndOpen(repo, id);
            }
        }
        return super.openHandle(repo);
    }

    /*
     * Exception decompiling
     */
    private AbstractChangeNotes.LoadHandle rebuildAndOpen(Repository repo, ObjectId oldId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Singleton
    public static class Factory {
        private final AbstractChangeNotes.Args args;
        private final Provider<InternalChangeQuery> queryProvider;
        private final ProjectCache projectCache;

        @Inject
        @VisibleForTesting
        public Factory(AbstractChangeNotes.Args args, Provider<InternalChangeQuery> queryProvider, ProjectCache projectCache) {
            this.args = args;
            this.queryProvider = queryProvider;
            this.projectCache = projectCache;
        }

        public ChangeNotes createChecked(ReviewDb db, Change c) throws OrmException {
            return this.createChecked(db, c.getProject(), c.getId());
        }

        public ChangeNotes createChecked(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            Change change = ChangeNotes.readOneReviewDbChange(db, changeId);
            if (change == null) {
                if (!this.args.migration.readChanges()) {
                    throw new NoSuchChangeException(changeId);
                }
                change = Factory.newNoteDbOnlyChange(project, changeId);
            } else if (!change.getProject().equals(project)) {
                throw new NoSuchChangeException(changeId);
            }
            return (ChangeNotes)new ChangeNotes(this.args, change).load();
        }

        public ChangeNotes createChecked(Change.Id changeId) throws OrmException {
            InternalChangeQuery query = this.queryProvider.get().noFields();
            List<ChangeData> changes = query.byLegacyChangeId(changeId);
            if (changes.isEmpty()) {
                throw new NoSuchChangeException(changeId);
            }
            if (changes.size() != 1) {
                log.error("Multiple changes found for {}", (Object)changeId.get());
                throw new NoSuchChangeException(changeId);
            }
            return changes.get(0).notes();
        }

        public static Change newNoteDbOnlyChange(Project.NameKey project, Change.Id changeId) {
            Change change = new Change(null, changeId, null, new Branch.NameKey(project, "INVALID_NOTE_DB_ONLY"), null);
            change.setNoteDbState("N");
            return change;
        }

        private Change loadChangeFromDb(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            Preconditions.checkArgument(project != null, "project is required");
            Change change = ChangeNotes.readOneReviewDbChange(db, changeId);
            if (change == null) {
                if (this.args.migration.readChanges()) {
                    return Factory.newNoteDbOnlyChange(project, changeId);
                }
                throw new NoSuchChangeException(changeId);
            }
            Preconditions.checkArgument(change.getProject().equals(project), "passed project %s when creating ChangeNotes for %s, but actual project is %s", (Object)project, (Object)changeId, (Object)change.getProject());
            return change;
        }

        public ChangeNotes create(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            return (ChangeNotes)new ChangeNotes(this.args, this.loadChangeFromDb(db, project, changeId)).load();
        }

        public ChangeNotes createWithAutoRebuildingDisabled(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            return (ChangeNotes)new ChangeNotes(this.args, this.loadChangeFromDb(db, project, changeId), true, false, null).load();
        }

        public ChangeNotes createFromIndexedChange(Change change) {
            return new ChangeNotes(this.args, change);
        }

        public ChangeNotes createForBatchUpdate(Change change, boolean shouldExist) throws OrmException {
            return (ChangeNotes)new ChangeNotes(this.args, change, shouldExist, false, null).load();
        }

        public ChangeNotes createWithAutoRebuildingDisabled(Change change, RefCache refs) throws OrmException {
            return (ChangeNotes)new ChangeNotes(this.args, change, true, false, refs).load();
        }

        private ChangeNotes createFromChangeOnlyWhenNoteDbDisabled(Change change) throws OrmException {
            Preconditions.checkState(!this.args.migration.readChanges(), "do not call createFromChangeWhenNoteDbDisabled when NoteDb is enabled");
            return (ChangeNotes)new ChangeNotes(this.args, change).load();
        }

        public List<ChangeNotes> create(ReviewDb db, Collection<Change.Id> changeIds) throws OrmException {
            ArrayList<ChangeNotes> notes = new ArrayList<ChangeNotes>();
            if (this.args.migration.enabled()) {
                for (Change.Id changeId : changeIds) {
                    try {
                        notes.add(this.createChecked(changeId));
                    }
                    catch (NoSuchChangeException noSuchChangeException) {}
                }
                return notes;
            }
            for (Change c : ReviewDbUtil.unwrapDb(db).changes().get(changeIds)) {
                notes.add(this.createFromChangeOnlyWhenNoteDbDisabled(c));
            }
            return notes;
        }

        public List<ChangeNotes> create(ReviewDb db, Project.NameKey project, Collection<Change.Id> changeIds, Predicate<ChangeNotes> predicate) throws OrmException {
            ArrayList<ChangeNotes> notes = new ArrayList<ChangeNotes>();
            if (this.args.migration.enabled()) {
                for (Change.Id cid : changeIds) {
                    ChangeNotes cn = this.create(db, project, cid);
                    if (cn.getChange() == null || !predicate.test(cn)) continue;
                    notes.add(cn);
                }
                return notes;
            }
            for (Change c : ReviewDbUtil.unwrapDb(db).changes().get(changeIds)) {
                ChangeNotes cn;
                if (c == null || !project.equals(c.getDest().getParentKey()) || !predicate.test(cn = this.createFromChangeOnlyWhenNoteDbDisabled(c))) continue;
                notes.add(cn);
            }
            return notes;
        }

        public ListMultimap<Project.NameKey, ChangeNotes> create(ReviewDb db, Predicate<ChangeNotes> predicate) throws IOException, OrmException {
            Multimap m = MultimapBuilder.hashKeys().arrayListValues().build();
            if (this.args.migration.readChanges()) {
                for (Project.NameKey project : this.projectCache.all()) {
                    Repository repo = this.args.repoManager.openRepository(project);
                    Throwable throwable = null;
                    try {
                        List<ChangeNotes> changes = this.scanNoteDb(repo, db, project);
                        for (ChangeNotes cn : changes) {
                            if (!predicate.test(cn)) continue;
                            m.put(project, cn);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (repo == null) continue;
                        if (throwable != null) {
                            try {
                                repo.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        repo.close();
                    }
                }
            } else {
                for (Change change : ReviewDbUtil.unwrapDb(db).changes().all()) {
                    ChangeNotes notes = this.createFromChangeOnlyWhenNoteDbDisabled(change);
                    if (!predicate.test(notes)) continue;
                    m.put(change.getProject(), notes);
                }
            }
            return ImmutableListMultimap.copyOf(m);
        }

        public List<ChangeNotes> scan(Repository repo, ReviewDb db, Project.NameKey project) throws OrmException, IOException {
            if (!this.args.migration.readChanges()) {
                return this.scanDb(repo, db);
            }
            return this.scanNoteDb(repo, db, project);
        }

        private List<ChangeNotes> scanDb(Repository repo, ReviewDb db) throws OrmException, IOException {
            Set<Change.Id> ids = Factory.scan(repo);
            ArrayList<ChangeNotes> notes = new ArrayList<ChangeNotes>(ids.size());
            for (List<Change.Id> batch : Iterables.partition(ids, 30)) {
                for (Change change : ReviewDbUtil.unwrapDb(db).changes().get(batch)) {
                    notes.add(this.createFromChangeOnlyWhenNoteDbDisabled(change));
                }
            }
            return notes;
        }

        private List<ChangeNotes> scanNoteDb(Repository repo, ReviewDb db, Project.NameKey project) throws OrmException, IOException {
            Set<Change.Id> ids = Factory.scan(repo);
            ArrayList<ChangeNotes> changeNotes = new ArrayList<ChangeNotes>(ids.size());
            NoteDbChangeState.PrimaryStorage defaultStorage = this.args.migration.changePrimaryStorage();
            for (Change.Id id : ids) {
                Change change = ChangeNotes.readOneReviewDbChange(db, id);
                if (change == null) {
                    if (defaultStorage == NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
                        log.warn("skipping change {} found in project {} but not in ReviewDb", (Object)id, (Object)project);
                        continue;
                    }
                    change = Factory.newNoteDbOnlyChange(project, id);
                } else if (!change.getProject().equals(project)) {
                    log.error("skipping change {} found in project {} because ReviewDb change has project {}", id, project, change.getProject());
                    continue;
                }
                log.debug("adding change {} found in project {}", (Object)id, (Object)project);
                changeNotes.add((ChangeNotes)new ChangeNotes(this.args, change).load());
            }
            return changeNotes;
        }

        public static Set<Change.Id> scan(Repository repo) throws IOException {
            Map<String, Ref> refs = repo.getRefDatabase().getRefs("refs/changes/");
            HashSet<Change.Id> ids = new HashSet<Change.Id>(refs.size());
            for (Ref r : refs.values()) {
                Change.Id id = Change.Id.fromRef(r.getName());
                if (id == null) continue;
                ids.add(id);
            }
            return ids;
        }
    }
}

