/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ChangeControl {
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final RefControl refControl;
    private final ChangeNotes notes;
    private final PatchSetUtil patchSetUtil;

    ChangeControl(ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, RefControl refControl, ChangeNotes notes, PatchSetUtil patchSetUtil) {
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
        this.refControl = refControl;
        this.notes = notes;
        this.patchSetUtil = patchSetUtil;
    }

    public ChangeControl forUser(CurrentUser who) {
        if (this.getUser().equals(who)) {
            return this;
        }
        return new ChangeControl(this.changeDataFactory, this.approvalsUtil, this.getRefControl().forUser(who), this.notes, this.patchSetUtil);
    }

    public RefControl getRefControl() {
        return this.refControl;
    }

    public CurrentUser getUser() {
        return this.getRefControl().getUser();
    }

    public ProjectControl getProjectControl() {
        return this.getRefControl().getProjectControl();
    }

    public Project getProject() {
        return this.getProjectControl().getProject();
    }

    public Change.Id getId() {
        return this.notes.getChangeId();
    }

    public Change getChange() {
        return this.notes.getChange();
    }

    public ChangeNotes getNotes() {
        return this.notes;
    }

    public boolean isVisible(ReviewDb db) throws OrmException {
        return this.isVisible(db, null);
    }

    public boolean isVisible(ReviewDb db, @Nullable ChangeData cd) throws OrmException {
        if (this.getChange().getStatus() == Change.Status.DRAFT && !this.isDraftVisible(db, cd)) {
            return false;
        }
        return this.isRefVisible();
    }

    public boolean isRefVisible() {
        return this.getRefControl().isVisible();
    }

    public boolean isPatchVisible(PatchSet ps, ReviewDb db) throws OrmException {
        if (ps != null && ps.isDraft() && !this.isDraftVisible(db, null)) {
            return false;
        }
        return this.isVisible(db);
    }

    public boolean isPatchVisible(PatchSet ps, ChangeData cd) throws OrmException {
        Preconditions.checkArgument(cd.getId().equals(ps.getId().getParentKey()), "%s not for change %s", (Object)ps, (Object)cd.getId());
        if (ps.isDraft() && !this.isDraftVisible(cd.db(), cd)) {
            return false;
        }
        return this.isVisible(cd.db());
    }

    public boolean canAbandon(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getUser().getCapabilities().canAdministrateServer() || this.getRefControl().canAbandon()) && !this.isPatchSetLocked(db);
    }

    public boolean canMoveTo(String ref, ReviewDb db) throws OrmException {
        return this.getProjectControl().controlForRef(ref).canUpload() && this.canAbandon(db);
    }

    public boolean canPublish(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().canPublishDrafts()) && this.isVisible(db);
    }

    public boolean canDelete(ReviewDb db, Change.Status status) throws OrmException {
        if (!this.isVisible(db)) {
            return false;
        }
        switch (status) {
            case DRAFT: {
                return this.isOwner() || this.getRefControl().canDeleteDrafts();
            }
            case NEW: 
            case ABANDONED: {
                return this.isAdmin() || this.getRefControl().canDeleteChanges(this.isOwner());
            }
        }
        return false;
    }

    public boolean canRebase(ReviewDb db) throws OrmException {
        return (this.isOwner() || this.getRefControl().canSubmit(this.isOwner()) || this.getRefControl().canRebase()) && !this.isPatchSetLocked(db);
    }

    public boolean canRestore(ReviewDb db) throws OrmException {
        return this.canAbandon(db) && this.getRefControl().canUpload();
    }

    public LabelTypes getLabelTypes() {
        String destBranch = this.getChange().getDest().get();
        List<LabelType> all = this.getProjectControl().getLabelTypes().getLabelTypes();
        ArrayList<LabelType> r = Lists.newArrayListWithCapacity(all.size());
        block0: for (LabelType l : all) {
            List<String> refs = l.getRefPatterns();
            if (refs == null) {
                r.add(l);
                continue;
            }
            for (String refPattern : refs) {
                if (!RefConfigSection.isValid(refPattern) || !this.match(destBranch, refPattern)) continue;
                r.add(l);
                continue block0;
            }
        }
        return new LabelTypes(r);
    }

    public List<PermissionRange> getLabelRanges() {
        return this.getRefControl().getLabelRanges(this.isOwner());
    }

    public PermissionRange getRange(String permission) {
        return this.getRefControl().getRange(permission, this.isOwner());
    }

    public boolean canAddPatchSet(ReviewDb db) throws OrmException {
        if (!this.getRefControl().canUpload() || this.isPatchSetLocked(db) || !this.isPatchVisible(this.patchSetUtil.current(db, this.notes), db)) {
            return false;
        }
        if (this.isOwner()) {
            return true;
        }
        return this.getRefControl().canAddPatchSet();
    }

    public boolean isPatchSetLocked(ReviewDb db) throws OrmException {
        if (this.getChange().getStatus() == Change.Status.MERGED) {
            return false;
        }
        for (PatchSetApproval ap : this.approvalsUtil.byPatchSet(db, this, this.getChange().currentPatchSetId())) {
            LabelType type = this.getLabelTypes().byLabel(ap.getLabel());
            if (type == null || ap.getValue() != 1 || !type.getFunctionName().equalsIgnoreCase("PatchSetLock")) continue;
            return true;
        }
        return false;
    }

    public boolean isOwner() {
        if (this.getUser().isIdentifiedUser()) {
            Account.Id id = this.getUser().asIdentifiedUser().getAccountId();
            return id.equals(this.getChange().getOwner());
        }
        return false;
    }

    public boolean isAssignee() {
        Account.Id currentAssignee = this.notes.getChange().getAssignee();
        if (currentAssignee != null && this.getUser().isIdentifiedUser()) {
            Account.Id id = this.getUser().getAccountId();
            return id.equals(currentAssignee);
        }
        return false;
    }

    public boolean isReviewer(ReviewDb db) throws OrmException {
        return this.isReviewer(db, null);
    }

    public boolean isReviewer(ReviewDb db, @Nullable ChangeData cd) throws OrmException {
        if (this.getUser().isIdentifiedUser()) {
            ImmutableSet<Account.Id> results = this.changeData(db, cd).reviewers().all();
            return results.contains(this.getUser().getAccountId());
        }
        return false;
    }

    public boolean isAdmin() {
        return this.getUser().getCapabilities().canAdministrateServer();
    }

    public boolean canRemoveReviewer(PatchSetApproval approval) {
        return this.canRemoveReviewer(approval.getAccountId(), approval.getValue());
    }

    public boolean canRemoveReviewer(Account.Id reviewer, int value) {
        if (this.getChange().getStatus().isOpen()) {
            if (this.getUser().isIdentifiedUser() && this.getUser().getAccountId().equals(reviewer)) {
                return true;
            }
            if (this.isOwner() && 0 <= value) {
                return true;
            }
            if (this.getRefControl().canRemoveReviewer() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getUser().getCapabilities().canAdministrateServer()) {
                return true;
            }
        }
        return false;
    }

    public boolean canEditTopicName() {
        if (this.getChange().getStatus().isOpen()) {
            return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getUser().getCapabilities().canAdministrateServer() || this.getRefControl().canEditTopicName();
        }
        return this.getRefControl().canForceEditTopicName();
    }

    public boolean canEditDescription() {
        if (this.getChange().getStatus().isOpen()) {
            return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getUser().getCapabilities().canAdministrateServer();
        }
        return false;
    }

    public boolean canEditAssignee() {
        return this.isOwner() || this.getProjectControl().isOwner() || this.getRefControl().canEditAssignee() || this.isAssignee();
    }

    public boolean canEditHashtags() {
        return this.isOwner() || this.getRefControl().isOwner() || this.getProjectControl().isOwner() || this.getUser().getCapabilities().canAdministrateServer() || this.getRefControl().canEditHashtags();
    }

    public boolean canSubmit() {
        return this.getRefControl().canSubmit(this.isOwner());
    }

    public boolean canSubmitAs() {
        return this.getRefControl().canSubmitAs();
    }

    private boolean match(String destBranch, String refPattern) {
        return RefPatternMatcher.getMatcher(refPattern).match(destBranch, this.getUser());
    }

    private ChangeData changeData(ReviewDb db, @Nullable ChangeData cd) {
        return cd != null ? cd : this.changeDataFactory.create(db, this);
    }

    public boolean isDraftVisible(ReviewDb db, ChangeData cd) throws OrmException {
        return this.isOwner() || this.isReviewer(db, cd) || this.getRefControl().canViewDrafts() || this.getUser().isInternalUser();
    }

    @Singleton
    public static class Factory {
        private final ChangeData.Factory changeDataFactory;
        private final ChangeNotes.Factory notesFactory;
        private final ApprovalsUtil approvalsUtil;
        private final PatchSetUtil patchSetUtil;

        @Inject
        Factory(ChangeData.Factory changeDataFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, PatchSetUtil patchSetUtil) {
            this.changeDataFactory = changeDataFactory;
            this.notesFactory = notesFactory;
            this.approvalsUtil = approvalsUtil;
            this.patchSetUtil = patchSetUtil;
        }

        ChangeControl create(RefControl refControl, ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
            return this.create(refControl, this.notesFactory.create(db, project, changeId));
        }

        ChangeControl createForIndexedChange(RefControl refControl, Change change) {
            return this.create(refControl, this.notesFactory.createFromIndexedChange(change));
        }

        ChangeControl create(RefControl refControl, ChangeNotes notes) {
            return new ChangeControl(this.changeDataFactory, this.approvalsUtil, refControl, notes, this.patchSetUtil);
        }
    }

    @Singleton
    public static class GenericFactory {
        private final ProjectControl.GenericFactory projectControl;
        private final ChangeNotes.Factory notesFactory;

        @Inject
        GenericFactory(ProjectControl.GenericFactory p, ChangeNotes.Factory n) {
            this.projectControl = p;
            this.notesFactory = n;
        }

        public ChangeControl controlFor(ReviewDb db, Project.NameKey project, Change.Id changeId, CurrentUser user) throws OrmException {
            return this.controlFor(this.notesFactory.create(db, project, changeId), user);
        }

        public ChangeControl controlFor(ReviewDb db, Change change, CurrentUser user) throws OrmException {
            Project.NameKey projectKey = change.getProject();
            try {
                return this.projectControl.controlFor(projectKey, user).controlFor(db, change);
            }
            catch (NoSuchProjectException e) {
                throw new NoSuchChangeException(change.getId(), (Throwable)e);
            }
            catch (IOException e) {
                throw new NoSuchChangeException(change.getId(), (Throwable)e);
            }
        }

        public ChangeControl controlFor(ChangeNotes notes, CurrentUser user) throws NoSuchChangeException {
            try {
                return this.projectControl.controlFor(notes.getProjectName(), user).controlFor(notes);
            }
            catch (NoSuchProjectException | IOException e) {
                throw new NoSuchChangeException(notes.getChangeId(), (Throwable)e);
            }
        }

        public ChangeControl validateFor(ReviewDb db, Change.Id changeId, CurrentUser user) throws OrmException {
            return this.validateFor(db, this.notesFactory.createChecked(changeId), user);
        }

        public ChangeControl validateFor(ReviewDb db, ChangeNotes notes, CurrentUser user) throws OrmException {
            ChangeControl c = this.controlFor(notes, user);
            if (!c.isVisible(db)) {
                throw new NoSuchChangeException(c.getId());
            }
            return c;
        }
    }
}

