/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.CommitResource;
import com.google.gerrit.server.project.FileResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class FilesInCommitCollection
implements ChildCollection<CommitResource, FileResource> {
    private final DynamicMap<RestView<FileResource>> views;
    private final GitRepositoryManager repoManager;

    @Inject
    FilesInCommitCollection(DynamicMap<RestView<FileResource>> views, GitRepositoryManager repoManager) {
        this.views = views;
        this.repoManager = repoManager;
    }

    @Override
    public RestView<CommitResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public FileResource parse(CommitResource parent, IdString id) throws ResourceNotFoundException, IOException {
        if (Patch.isMagic(id.get())) {
            return new FileResource(parent.getProject(), parent.getCommit(), id.get());
        }
        return FileResource.create(this.repoManager, parent.getProject(), parent.getCommit(), id.get());
    }

    @Override
    public DynamicMap<RestView<FileResource>> views() {
        return this.views;
    }
}

