/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RuleEvalException;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.googlecode.prolog_cafe.exceptions.CompileException;
import com.googlecode.prolog_cafe.exceptions.ReductionLimitException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitRuleEvaluator {
    private static final Logger log = LoggerFactory.getLogger(SubmitRuleEvaluator.class);
    private static final String DEFAULT_MSG = "Error evaluating project rules, check server log";
    private final ChangeData cd;
    private final ChangeControl control;
    private SubmitRuleOptions.Builder optsBuilder = SubmitRuleOptions.defaults();
    private SubmitRuleOptions opts;
    private PatchSet patchSet;
    private boolean logErrors = true;
    private long reductionsConsumed;
    private Term submitRule;

    public static List<SubmitRecord> defaultRuleError() {
        return SubmitRuleEvaluator.createRuleError(DEFAULT_MSG);
    }

    public static List<SubmitRecord> createRuleError(String err) {
        SubmitRecord rec = new SubmitRecord();
        rec.status = SubmitRecord.Status.RULE_ERROR;
        rec.errorMessage = err;
        return Collections.singletonList(rec);
    }

    public static SubmitTypeRecord defaultTypeError() {
        return SubmitTypeRecord.error(DEFAULT_MSG);
    }

    public SubmitRuleEvaluator(ChangeData cd) throws OrmException {
        this.cd = cd;
        this.control = cd.changeControl();
    }

    public SubmitRuleOptions getOptions() {
        if (this.opts != null) {
            return this.opts;
        }
        return this.optsBuilder.build();
    }

    public SubmitRuleEvaluator setOptions(SubmitRuleOptions opts) {
        this.checkNotStarted();
        this.optsBuilder = opts != null ? opts.toBuilder() : SubmitRuleOptions.defaults();
        return this;
    }

    public SubmitRuleEvaluator setPatchSet(PatchSet ps) {
        Preconditions.checkArgument(ps.getId().getParentKey().equals(this.cd.getId()), "Patch set %s does not match change %s", (Object)ps.getId(), (Object)this.cd.getId());
        this.patchSet = ps;
        return this;
    }

    public SubmitRuleEvaluator setFastEvalLabels(boolean fast) {
        this.checkNotStarted();
        this.optsBuilder.fastEvalLabels(fast);
        return this;
    }

    public SubmitRuleEvaluator setAllowClosed(boolean allow) {
        this.checkNotStarted();
        this.optsBuilder.allowClosed(allow);
        return this;
    }

    public SubmitRuleEvaluator setAllowDraft(boolean allow) {
        this.checkNotStarted();
        this.optsBuilder.allowDraft(allow);
        return this;
    }

    public SubmitRuleEvaluator setSkipSubmitFilters(boolean skip) {
        this.checkNotStarted();
        this.optsBuilder.skipFilters(skip);
        return this;
    }

    public SubmitRuleEvaluator setRule(@Nullable String rule) {
        this.checkNotStarted();
        this.optsBuilder.rule(rule);
        return this;
    }

    public SubmitRuleEvaluator setLogErrors(boolean log) {
        this.logErrors = log;
        return this;
    }

    public long getReductionsConsumed() {
        return this.reductionsConsumed;
    }

    public List<SubmitRecord> evaluate() {
        List<Term> results;
        this.initOptions();
        Change c = this.control.getChange();
        if (!this.opts.allowClosed() && c.getStatus().isClosed()) {
            SubmitRecord rec = new SubmitRecord();
            rec.status = SubmitRecord.Status.CLOSED;
            return Collections.singletonList(rec);
        }
        if (!this.opts.allowDraft()) {
            try {
                this.initPatchSet();
            }
            catch (OrmException e) {
                return this.ruleError("Error looking up patch set " + this.control.getChange().currentPatchSetId(), e);
            }
            if (c.getStatus() == Change.Status.DRAFT || this.patchSet.isDraft()) {
                return this.cannotSubmitDraft();
            }
        }
        try {
            results = this.evaluateImpl("locate_submit_rule", "can_submit", "locate_submit_filter", "filter_submit_results", this.control.getUser());
        }
        catch (RuleEvalException e) {
            return this.ruleError(e.getMessage(), e);
        }
        if (results.isEmpty()) {
            return this.ruleError(String.format("Submit rule '%s' for change %s of %s has no solution.", this.getSubmitRuleName(), this.cd.getId(), this.getProjectName()));
        }
        return this.resultsToSubmitRecord(this.getSubmitRule(), results);
    }

    private List<SubmitRecord> cannotSubmitDraft() {
        try {
            if (!this.control.isDraftVisible(this.cd.db(), this.cd)) {
                return SubmitRuleEvaluator.createRuleError("Patch set " + this.patchSet.getId() + " not found");
            }
            if (this.patchSet.isDraft()) {
                return SubmitRuleEvaluator.createRuleError("Cannot submit draft patch sets");
            }
            return SubmitRuleEvaluator.createRuleError("Cannot submit draft changes");
        }
        catch (OrmException err) {
            PatchSet.Id psId = this.patchSet != null ? this.patchSet.getId() : this.control.getChange().currentPatchSetId();
            String msg = "Cannot check visibility of patch set " + psId;
            log.error(msg, err);
            return SubmitRuleEvaluator.createRuleError(msg);
        }
    }

    private List<SubmitRecord> resultsToSubmitRecord(Term submitRule, List<Term> results) {
        ArrayList<SubmitRecord> out = new ArrayList<SubmitRecord>(results.size());
        for (int resultIdx = results.size() - 1; 0 <= resultIdx; --resultIdx) {
            Term submitRecord = results.get(resultIdx);
            SubmitRecord rec = new SubmitRecord();
            out.add(rec);
            if (!(submitRecord instanceof StructureTerm) || 1 != submitRecord.arity()) {
                return this.invalidResult(submitRule, submitRecord);
            }
            if ("ok".equals(submitRecord.name())) {
                rec.status = SubmitRecord.Status.OK;
            } else if ("not_ready".equals(submitRecord.name())) {
                rec.status = SubmitRecord.Status.NOT_READY;
            } else {
                return this.invalidResult(submitRule, submitRecord);
            }
            submitRecord = submitRecord.arg(0);
            if (!(submitRecord instanceof StructureTerm)) {
                return this.invalidResult(submitRule, submitRecord);
            }
            rec.labels = new ArrayList<SubmitRecord.Label>(submitRecord.arity());
            for (Term state : ((StructureTerm)submitRecord).args()) {
                if (!(state instanceof StructureTerm) || 2 != state.arity() || !"label".equals(state.name())) {
                    return this.invalidResult(submitRule, submitRecord);
                }
                SubmitRecord.Label lbl = new SubmitRecord.Label();
                rec.labels.add(lbl);
                lbl.label = state.arg(0).name();
                Term status = state.arg(1);
                try {
                    if ("ok".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.OK;
                        this.appliedBy(lbl, status);
                        continue;
                    }
                    if ("reject".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.REJECT;
                        this.appliedBy(lbl, status);
                        continue;
                    }
                    if ("need".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.NEED;
                        continue;
                    }
                    if ("may".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.MAY;
                        continue;
                    }
                    if ("impossible".equals(status.name())) {
                        lbl.status = SubmitRecord.Label.Status.IMPOSSIBLE;
                        continue;
                    }
                    return this.invalidResult(submitRule, submitRecord);
                }
                catch (UserTermExpected e) {
                    return this.invalidResult(submitRule, submitRecord, e.getMessage());
                }
            }
            if (rec.status == SubmitRecord.Status.OK) break;
        }
        Collections.reverse(out);
        return out;
    }

    private List<SubmitRecord> invalidResult(Term rule, Term record, String reason) {
        return this.ruleError(String.format("Submit rule %s for change %s of %s output invalid result: %s%s", rule, this.cd.getId(), this.getProjectName(), record, reason == null ? "" : ". Reason: " + reason));
    }

    private List<SubmitRecord> invalidResult(Term rule, Term record) {
        return this.invalidResult(rule, record, null);
    }

    private List<SubmitRecord> ruleError(String err) {
        return this.ruleError(err, null);
    }

    private List<SubmitRecord> ruleError(String err, Exception e) {
        if (this.logErrors) {
            if (e == null) {
                log.error(err);
            } else {
                log.error(err, e);
            }
            return SubmitRuleEvaluator.defaultRuleError();
        }
        return SubmitRuleEvaluator.createRuleError(err);
    }

    public SubmitTypeRecord getSubmitType() {
        List<Term> results;
        this.initOptions();
        try {
            this.initPatchSet();
        }
        catch (OrmException e) {
            return this.typeError("Error looking up patch set " + this.control.getChange().currentPatchSetId(), e);
        }
        try {
            if (this.control.getChange().getStatus() == Change.Status.DRAFT && !this.control.isDraftVisible(this.cd.db(), this.cd)) {
                return SubmitTypeRecord.error("Patch set " + this.patchSet.getId() + " not found");
            }
            if (this.patchSet.isDraft() && !this.control.isDraftVisible(this.cd.db(), this.cd)) {
                return SubmitTypeRecord.error("Patch set " + this.patchSet.getId() + " not found");
            }
        }
        catch (OrmException err) {
            String msg = "Cannot read patch set " + this.patchSet.getId();
            log.error(msg, err);
            return SubmitTypeRecord.error(msg);
        }
        try {
            results = this.evaluateImpl("locate_submit_type", "get_submit_type", "locate_submit_type_filter", "filter_submit_type_results", null);
        }
        catch (RuleEvalException e) {
            return this.typeError(e.getMessage(), e);
        }
        if (results.isEmpty()) {
            return this.typeError("Submit rule '" + this.getSubmitRuleName() + "' for change " + this.cd.getId() + " of " + this.getProjectName() + " has no solution.");
        }
        Term typeTerm = results.get(0);
        if (!(typeTerm instanceof SymbolTerm)) {
            return this.typeError("Submit rule '" + this.getSubmitRuleName() + "' for change " + this.cd.getId() + " of " + this.getProjectName() + " did not return a symbol.");
        }
        String typeName = ((SymbolTerm)typeTerm).name();
        try {
            return SubmitTypeRecord.OK(SubmitType.valueOf(typeName.toUpperCase()));
        }
        catch (IllegalArgumentException e) {
            return this.typeError("Submit type rule " + this.getSubmitRule() + " for change " + this.cd.getId() + " of " + this.getProjectName() + " output invalid result: " + typeName);
        }
    }

    private SubmitTypeRecord typeError(String err) {
        return this.typeError(err, null);
    }

    private SubmitTypeRecord typeError(String err, Exception e) {
        if (this.logErrors) {
            if (e == null) {
                log.error(err);
            } else {
                log.error(err, e);
            }
            return SubmitRuleEvaluator.defaultTypeError();
        }
        return SubmitTypeRecord.error(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Term> evaluateImpl(String userRuleLocatorName, String userRuleWrapperName, String filterRuleLocatorName, String filterRuleWrapperName, CurrentUser user) throws RuleEvalException {
        try (PrologEnvironment env = this.getPrologEnvironment(user);){
            List<Term> r;
            Term sr = env.once("gerrit", userRuleLocatorName, (Term)new VariableTerm());
            if (this.opts.fastEvalLabels()) {
                env.once("gerrit", "assume_range_from_label", new Term[0]);
            }
            ArrayList<Term> results = new ArrayList<Term>();
            try {
                for (Term[] template : env.all("gerrit", userRuleWrapperName, sr, new VariableTerm())) {
                    results.add(template[1]);
                }
            }
            catch (ReductionLimitException err) {
                throw new RuleEvalException(String.format("%s on change %d of %s", err.getMessage(), this.cd.getId().get(), this.getProjectName()));
            }
            catch (RuntimeException err) {
                throw new RuleEvalException(String.format("Exception calling %s on change %d of %s", sr, this.cd.getId().get(), this.getProjectName()), err);
            }
            finally {
                this.reductionsConsumed = env.getReductions();
            }
            Term resultsTerm = SubmitRuleEvaluator.toListTerm(results);
            if (!this.opts.skipFilters()) {
                resultsTerm = this.runSubmitFilters(resultsTerm, env, filterRuleLocatorName, filterRuleWrapperName);
            }
            if (resultsTerm instanceof ListTerm) {
                r = new ArrayList();
                Term t = resultsTerm;
                while (t instanceof ListTerm) {
                    ListTerm l = (ListTerm)t;
                    r.add(l.car().dereference());
                    t = l.cdr().dereference();
                }
            } else {
                r = Collections.emptyList();
            }
            this.submitRule = sr;
            List<Term> list = r;
            return list;
        }
    }

    private PrologEnvironment getPrologEnvironment(CurrentUser user) throws RuleEvalException {
        PrologEnvironment env;
        ProjectState projectState = this.control.getProjectControl().getProjectState();
        try {
            env = this.opts.rule() == null ? projectState.newPrologEnvironment() : projectState.newPrologEnvironment("stdin", new StringReader(this.opts.rule()));
        }
        catch (CompileException err) {
            String msg = this.opts.rule() == null && this.control.getProjectControl().isOwner() ? String.format("Cannot load rules.pl for %s: %s", this.getProjectName(), err.getMessage()) : (this.opts.rule() != null ? err.getMessage() : String.format("Cannot load rules.pl for %s", this.getProjectName()));
            throw new RuleEvalException(msg, err);
        }
        env.set(StoredValues.REVIEW_DB, this.cd.db());
        env.set(StoredValues.CHANGE_DATA, this.cd);
        env.set(StoredValues.CHANGE_CONTROL, this.control);
        if (user != null) {
            env.set(StoredValues.CURRENT_USER, user);
        }
        return env;
    }

    private Term runSubmitFilters(Term results, PrologEnvironment env, String filterRuleLocatorName, String filterRuleWrapperName) throws RuleEvalException {
        ProjectState projectState = this.control.getProjectControl().getProjectState();
        PrologEnvironment childEnv = env;
        for (ProjectState parentState : projectState.parents()) {
            PrologEnvironment parentEnv;
            try {
                parentEnv = parentState.newPrologEnvironment();
            }
            catch (CompileException err) {
                throw new RuleEvalException("Cannot consult rules.pl for " + parentState.getProject().getName(), err);
            }
            parentEnv.copyStoredValues(childEnv);
            Term filterRule = parentEnv.once("gerrit", filterRuleLocatorName, (Term)new VariableTerm());
            try {
                if (this.opts.fastEvalLabels()) {
                    env.once("gerrit", "assume_range_from_label", new Term[0]);
                }
                Term[] template = parentEnv.once("gerrit", filterRuleWrapperName, filterRule, results, new VariableTerm());
                results = template[2];
            }
            catch (ReductionLimitException err) {
                throw new RuleEvalException(String.format("%s on change %d of %s", err.getMessage(), this.cd.getId().get(), parentState.getProject().getName()));
            }
            catch (RuntimeException err) {
                throw new RuleEvalException(String.format("Exception calling %s on change %d of %s", filterRule, this.cd.getId().get(), parentState.getProject().getName()), err);
            }
            finally {
                this.reductionsConsumed += env.getReductions();
            }
            childEnv = parentEnv;
        }
        return results;
    }

    private static Term toListTerm(List<Term> terms) {
        Term list = Prolog.Nil;
        for (int i = terms.size() - 1; i >= 0; --i) {
            list = new ListTerm(terms.get(i), list);
        }
        return list;
    }

    private void appliedBy(SubmitRecord.Label label, Term status) throws UserTermExpected {
        if (status instanceof StructureTerm && status.arity() == 1) {
            Term who = status.arg(0);
            if (SubmitRuleEvaluator.isUser(who)) {
                label.appliedBy = new Account.Id(((IntegerTerm)who.arg(0)).intValue());
            } else {
                throw new UserTermExpected(label);
            }
        }
    }

    private static boolean isUser(Term who) {
        return who instanceof StructureTerm && who.arity() == 1 && who.name().equals("user") && who.arg(0) instanceof IntegerTerm;
    }

    public Term getSubmitRule() {
        Preconditions.checkState(this.submitRule != null, "getSubmitRule() invalid before evaluation");
        return this.submitRule;
    }

    public String getSubmitRuleName() {
        return this.submitRule != null ? this.submitRule.toString() : "<unknown rule>";
    }

    private void checkNotStarted() {
        Preconditions.checkState(this.opts == null, "cannot set options after starting evaluation");
    }

    private void initOptions() {
        if (this.opts == null) {
            this.opts = this.optsBuilder.build();
            this.optsBuilder = null;
        }
    }

    private void initPatchSet() throws OrmException {
        if (this.patchSet == null) {
            this.patchSet = this.cd.currentPatchSet();
            if (this.patchSet == null) {
                throw new OrmException("No patch set found");
            }
        }
    }

    private String getProjectName() {
        return this.control.getProjectControl().getProjectState().getProject().getName();
    }

    private static class UserTermExpected
    extends Exception {
        private static final long serialVersionUID = 1L;

        UserTermExpected(SubmitRecord.Label label) {
            super(String.format("A label with the status %s must contain a user.", label.toString()));
        }
    }
}

