/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.IntPredicate;
import com.google.gerrit.server.query.Matchable;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.QueryParseException;

public class LimitPredicate<T>
extends IntPredicate<T>
implements Matchable<T> {
    public static Integer getLimit(String fieldName, Predicate<?> p) {
        IntPredicate ip = QueryBuilder.find(p, IntPredicate.class, fieldName);
        return ip != null ? Integer.valueOf(ip.intValue()) : null;
    }

    public LimitPredicate(String fieldName, int limit) throws QueryParseException {
        super(fieldName, limit);
        if (limit <= 0) {
            throw new QueryParseException("limit must be positive: " + limit);
        }
    }

    @Override
    public boolean match(T object) {
        return true;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

