/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.account;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.PostFilterPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Objects;

public class CanSeeChangePredicate
extends PostFilterPredicate<AccountState> {
    private final Provider<ReviewDb> db;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ChangeNotes changeNotes;

    CanSeeChangePredicate(Provider<ReviewDb> db, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ChangeNotes changeNotes) {
        this.db = db;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.changeNotes = changeNotes;
    }

    @Override
    public boolean match(AccountState accountState) throws OrmException {
        return this.changeControlFactory.controlFor(this.changeNotes, this.userFactory.create(accountState.getAccount().getId())).isVisible(this.db.get());
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public Predicate<AccountState> copy(Collection<? extends Predicate<AccountState>> children) {
        return new CanSeeChangePredicate(this.db, this.changeControlFactory, this.userFactory, this.changeNotes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.changeNotes.getChange().getChangeId());
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.getClass() == other.getClass() && this.changeNotes.getChange().getChangeId() == ((CanSeeChangePredicate)other).changeNotes.getChange().getChangeId();
    }
}

