/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.Collections;
import java.util.List;

class EqualsPathPredicate
extends ChangeIndexPredicate {
    private final String value;

    EqualsPathPredicate(String fieldName, String value) {
        super(ChangeField.PATH, fieldName, value);
        this.value = value;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        List<String> files = object.currentFilePaths();
        return files != null && Collections.binarySearch(files, this.value) >= 0;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

