/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.systemstatus.ServerInformation;
import com.google.gerrit.server.util.SystemLog;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class PluginLogFile
implements LifecycleListener {
    private final SystemLog systemLog;
    private final ServerInformation serverInfo;
    private final String logName;
    private final Layout layout;

    public PluginLogFile(SystemLog systemLog, ServerInformation serverInfo, String logName, Layout layout) {
        this.systemLog = systemLog;
        this.serverInfo = serverInfo;
        this.logName = logName;
        this.layout = layout;
    }

    @Override
    public void start() {
        AsyncAppender asyncAppender = this.systemLog.createAsyncAppender(this.logName, this.layout, true);
        Logger logger = LogManager.getLogger(this.logName);
        logger.removeAppender(this.logName);
        logger.addAppender(asyncAppender);
        logger.setAdditivity(false);
    }

    @Override
    public void stop() {
        if (this.serverInfo.getState() == ServerInformation.State.SHUTDOWN) {
            LogManager.getLogger(this.logName).removeAllAppenders();
        }
    }
}

