/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.concurrent.Callable;

public abstract class ThreadLocalRequestScopePropagator<C>
extends RequestScopePropagator {
    private final ThreadLocal<C> threadLocal;

    protected ThreadLocalRequestScopePropagator(Scope scope, ThreadLocal<C> threadLocal, ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
        super(scope, local, dbProviderProvider);
        this.threadLocal = threadLocal;
    }

    @Override
    protected final <T> Callable<T> wrapImpl(final Callable<T> callable) {
        final C ctx = this.continuingContext(this.requireContext());
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object old = ThreadLocalRequestScopePropagator.this.threadLocal.get();
                ThreadLocalRequestScopePropagator.this.threadLocal.set(ctx);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (old != null) {
                        ThreadLocalRequestScopePropagator.this.threadLocal.set(old);
                    } else {
                        ThreadLocalRequestScopePropagator.this.threadLocal.remove();
                    }
                }
            }
        };
    }

    private C requireContext() {
        C context = this.threadLocal.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object");
        }
        return context;
    }

    protected abstract C continuingContext(C var1);
}

