/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeFinder;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PatchSetParser {
    private final Provider<ReviewDb> db;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeNotes.Factory notesFactory;
    private final PatchSetUtil psUtil;
    private final ChangeFinder changeFinder;
    private final Provider<CurrentUser> self;

    @Inject
    PatchSetParser(Provider<ReviewDb> db, Provider<InternalChangeQuery> queryProvider, ChangeNotes.Factory notesFactory, PatchSetUtil psUtil, ChangeFinder changeFinder, Provider<CurrentUser> self) {
        this.db = db;
        this.queryProvider = queryProvider;
        this.notesFactory = notesFactory;
        this.psUtil = psUtil;
        this.changeFinder = changeFinder;
        this.self = self;
    }

    public PatchSet parsePatchSet(String token, ProjectControl projectControl, String branch) throws BaseCommand.UnloggedFailure, OrmException {
        if (token.matches("^([0-9a-fA-F]{4,40})$")) {
            List<ChangeData> cds;
            InternalChangeQuery query = this.queryProvider.get();
            if (projectControl != null) {
                Project.NameKey p = projectControl.getProject().getNameKey();
                cds = branch != null ? query.byBranchCommit(p.get(), branch, token) : query.byProjectCommit(p, token);
            } else {
                cds = query.byCommit(token);
            }
            ArrayList<PatchSet> matches = new ArrayList<PatchSet>(cds.size());
            for (ChangeData cd : cds) {
                Change c = cd.change();
                if (!PatchSetParser.inProject(c, projectControl) || !PatchSetParser.inBranch(c, branch)) continue;
                for (PatchSet ps : cd.patchSets()) {
                    if (!ps.getRevision().matches(token)) continue;
                    matches.add(ps);
                }
            }
            switch (matches.size()) {
                case 1: {
                    return (PatchSet)matches.iterator().next();
                }
                case 0: {
                    throw PatchSetParser.error("\"" + token + "\" no such patch set");
                }
            }
            throw PatchSetParser.error("\"" + token + "\" matches multiple patch sets");
        }
        if (token.matches("^[1-9][0-9]*,[1-9][0-9]*$")) {
            PatchSet.Id patchSetId;
            try {
                patchSetId = PatchSet.Id.parse(token);
            }
            catch (IllegalArgumentException e) {
                throw PatchSetParser.error("\"" + token + "\" is not a valid patch set");
            }
            ChangeNotes notes = this.getNotes(projectControl, patchSetId.getParentKey());
            PatchSet patchSet = this.psUtil.get(this.db.get(), notes, patchSetId);
            if (patchSet == null) {
                throw PatchSetParser.error("\"" + token + "\" no such patch set");
            }
            if (projectControl != null || branch != null) {
                Change change = notes.getChange();
                if (!PatchSetParser.inProject(change, projectControl)) {
                    throw PatchSetParser.error("change " + change.getId() + " not in project " + projectControl.getProject().getName());
                }
                if (!PatchSetParser.inBranch(change, branch)) {
                    throw PatchSetParser.error("change " + change.getId() + " not in branch " + branch);
                }
            }
            return patchSet;
        }
        throw PatchSetParser.error("\"" + token + "\" is not a valid patch set");
    }

    private ChangeNotes getNotes(@Nullable ProjectControl projectControl, Change.Id changeId) throws OrmException, BaseCommand.UnloggedFailure {
        if (projectControl != null) {
            return this.notesFactory.create(this.db.get(), projectControl.getProject().getNameKey(), changeId);
        }
        try {
            ChangeControl ctl = this.changeFinder.findOne(changeId, this.self.get());
            return this.notesFactory.create(this.db.get(), ctl.getProject().getNameKey(), changeId);
        }
        catch (NoSuchChangeException e) {
            throw PatchSetParser.error("\"" + changeId + "\" no such change");
        }
    }

    private static boolean inProject(Change change, ProjectControl projectControl) {
        if (projectControl == null) {
            return true;
        }
        return projectControl.getProject().getNameKey().equals(change.getProject());
    }

    private static boolean inBranch(Change change, String branch) {
        if (branch == null) {
            return true;
        }
        return change.getDest().get().equals(branch);
    }

    public static BaseCommand.UnloggedFailure error(String msg) {
        return new BaseCommand.UnloggedFailure(1, msg);
    }
}

