/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.internal.RenderableThunk;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.SoyString;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class StringData
extends PrimitiveData
implements SoyString {
    public static final StringData EMPTY_STRING = new ConstantString("");

    private StringData() {
    }

    public static StringData forValue(String value) {
        return value.length() == 0 ? EMPTY_STRING : new ConstantString(value);
    }

    public static StringData forThunk(RenderableThunk thunk) {
        return new LazyString(thunk);
    }

    public abstract String getValue();

    @Override
    public String stringValue() {
        return this.getValue();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public boolean coerceToBoolean() {
        return this.getValue().length() > 0;
    }

    @Override
    public String coerceToString() {
        return this.toString();
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getValue().equals(other.toString());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    private static final class LazyString
    extends StringData {
        final RenderableThunk thunk;

        LazyString(RenderableThunk thunk) {
            this.thunk = thunk;
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            this.thunk.render(appendable);
        }

        @Override
        public String getValue() {
            return this.thunk.renderAsString();
        }
    }

    private static final class ConstantString
    extends StringData {
        final String content;

        ConstantString(String content) {
            this.content = Preconditions.checkNotNull(content);
        }

        @Override
        public void render(Appendable appendable) throws IOException {
            appendable.append(this.content);
        }

        @Override
        public String getValue() {
            return this.content;
        }
    }
}

