/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.TreeMultimap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.html.AbstractHtmlSoyNodeVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.ConditionalBuilder;
import com.google.template.soy.jssrc.internal.AliasUtils;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenDirectivePluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenFunctionPluginRequiresVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.JsSrcNameGenerators;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.passes.FindIndirectParamsVisitor;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.internal.FindCalleesNotInFileVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.XidNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeOps;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import com.google.template.soy.types.proto.Protos;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;

public class GenJsCodeVisitor
extends AbstractHtmlSoyNodeVisitor<List<String>> {
    private static final SoyErrorKind NON_NAMESPACED_TEMPLATE = SoyErrorKind.of("Using the option to provide/require Soy namespaces, but called template does not reside in a namespace.");
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private static final String GOOG_IS_RTL_NAMESPACE = "goog.i18n.bidi";
    private static final String GOOG_MESSAGE_FORMAT_NAMESPACE = "goog.i18n.MessageFormat";
    protected final SoyJsSrcOptions jsSrcOptions;
    protected final JsExprTranslator jsExprTranslator;
    private final DelTemplateNamer delTemplateNamer;
    protected final GenCallCodeUtils genCallCodeUtils;
    protected final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
    private List<String> jsFilesContents;
    @VisibleForTesting
    JsCodeBuilder jsCodeBuilder;
    protected GenJsExprsVisitor genJsExprsVisitor;
    @VisibleForTesting
    GenJsCodeVisitorAssistantForMsgs assistantForMsgs;
    private GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor;
    protected TemplateRegistry templateRegistry;
    private final SoyTypeOps typeOps;
    protected ErrorReporter errorReporter;
    protected TranslationContext templateTranslationContext;
    @VisibleForTesting
    protected TemplateAliases templateAliases;

    @Inject
    protected GenJsCodeVisitor(SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, DelTemplateNamer delTemplateNamer, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory, GenDirectivePluginRequiresVisitor genDirectivePluginRequiresVisitor, SoyTypeOps typeOps) {
        this.jsSrcOptions = jsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.delTemplateNamer = delTemplateNamer;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJsExprsVisitorFactory = genJsExprsVisitorFactory;
        this.genDirectivePluginRequiresVisitor = genDirectivePluginRequiresVisitor;
        this.typeOps = typeOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> gen(SoyFileSetNode node, TemplateRegistry registry, ErrorReporter errorReporter) {
        this.templateRegistry = Preconditions.checkNotNull(registry);
        this.errorReporter = Preconditions.checkNotNull(errorReporter);
        try {
            this.jsFilesContents = new ArrayList<String>();
            this.jsCodeBuilder = null;
            this.genJsExprsVisitor = null;
            this.assistantForMsgs = null;
            this.visit(node);
            List<String> list = this.jsFilesContents;
            return list;
        }
        finally {
            this.templateRegistry = null;
            this.errorReporter = null;
        }
    }

    @Override
    @Deprecated
    public final List<String> exec(SoyNode node) {
        throw new UnsupportedOperationException();
    }

    public void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    @VisibleForTesting
    void visitForTesting(SoyNode node, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.visit(node);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        if (node.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(node.getChild(0))).booleanValue()) {
            this.jsCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList<CodeChunk.WithValue> consecChunks = new ArrayList<CodeChunk.WithValue>();
        for (SoyNode child : node.getChildren()) {
            if (((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) {
                consecChunks.addAll(this.genJsExprsVisitor.exec(child));
                continue;
            }
            if (!consecChunks.isEmpty()) {
                this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
                consecChunks.clear();
            }
            this.visit(child);
        }
        if (!consecChunks.isEmpty()) {
            this.jsCodeBuilder.addChunksToOutputVar(consecChunks);
            consecChunks.clear();
        }
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    protected JsCodeBuilder createCodeBuilder() {
        return new JsCodeBuilder();
    }

    protected JsCodeBuilder createChildJsCodeBuilder() {
        return new JsCodeBuilder(this.jsCodeBuilder);
    }

    protected JsCodeBuilder getJsCodeBuilder() {
        return this.jsCodeBuilder;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        if (node.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        StringBuilder file = new StringBuilder();
        file.append("// This file was automatically generated from ").append(node.getFileName()).append(".\n");
        file.append("// Please don't edit this file by hand.\n");
        file.append("\n");
        file.append("/**\n");
        String fileOverviewDescription = node.getNamespace() == null ? "" : " Templates in namespace " + node.getNamespace() + ".";
        file.append(" * @fileoverview").append(fileOverviewDescription).append('\n');
        file.append(" * @suppress {missingRequire}\n");
        if (node.getDelPackageName() != null) {
            file.append(" * @modName {").append(node.getDelPackageName()).append("}\n");
        }
        this.addJsDocToProvideDelTemplates(file, node);
        this.addJsDocToRequireDelTemplates(file, node);
        GenJsCodeVisitor.addCodeToRequireCss(file, node);
        file.append(" * @public\n").append(" */\n\n");
        this.templateAliases = AliasUtils.IDENTITY_ALIASES;
        this.jsCodeBuilder = this.createCodeBuilder();
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            this.templateAliases = AliasUtils.createTemplateAliases(node);
            this.addCodeToDeclareGoogModule(file, node);
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireGoogModules(node);
        } else if (this.jsSrcOptions.shouldProvideRequireSoyNamespaces()) {
            GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                GenJsCodeVisitor.addCodeToProvideJsFunctions(file, node);
            }
            file.append('\n');
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireSoyNamespaces(node);
        } else if (this.jsSrcOptions.shouldProvideRequireJsFunctions()) {
            if (this.jsSrcOptions.shouldProvideBothSoyNamespacesAndJsFunctions()) {
                GenJsCodeVisitor.addCodeToProvideSoyNamespace(file, node);
            }
            GenJsCodeVisitor.addCodeToProvideJsFunctions(file, node);
            file.append('\n');
            this.addCodeToRequireGeneralDeps(node);
            this.addCodeToRequireJsFunctions(node);
        } else {
            this.addCodeToDefineJsNamespaces(file, node);
        }
        for (TemplateNode template : node.getChildren()) {
            this.jsCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            this.visit(template);
        }
        this.jsCodeBuilder.appendGoogRequires(file);
        this.jsCodeBuilder.appendCode(file);
        this.jsFilesContents.add(file.toString());
        this.jsCodeBuilder = null;
    }

    private static void addCodeToRequireCss(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> requiredCssNamespaces = new TreeSet<String>();
        requiredCssNamespaces.addAll(soyFile.getRequiredCssNamespaces());
        for (TemplateNode template : soyFile.getChildren()) {
            requiredCssNamespaces.addAll(template.getRequiredCssNamespaces());
        }
        for (String requiredCssNamespace : requiredCssNamespaces) {
            header.append(" * @requirecss {").append(requiredCssNamespace).append("}\n");
        }
    }

    private void addCodeToDefineJsNamespaces(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> jsNamespaces = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            String templateName = template.getTemplateName();
            Matcher dotMatcher = DOT.matcher(templateName);
            while (dotMatcher.find()) {
                jsNamespaces.add(templateName.substring(0, dotMatcher.start()));
            }
        }
        for (String jsNamespace : jsNamespaces) {
            boolean hasDot;
            boolean bl = hasDot = jsNamespace.indexOf(46) >= 0;
            if (!this.jsSrcOptions.shouldDeclareTopLevelNamespaces() && !hasDot) continue;
            header.append("if (typeof ").append(jsNamespace).append(" == 'undefined') { ").append(hasDot ? "" : "var ").append(jsNamespace).append(" = {}; }\n");
        }
    }

    private static void addCodeToProvideSoyNamespace(StringBuilder header, SoyFileNode soyFile) {
        if (soyFile.getNamespace() != null) {
            header.append("goog.provide('").append(soyFile.getNamespace()).append("');\n");
        }
    }

    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace;
    }

    private void addCodeToDeclareGoogModule(StringBuilder header, SoyFileNode soyFile) {
        String exportNamespace = this.getGoogModuleNamespace(soyFile.getNamespace());
        header.append("goog.module('").append(exportNamespace).append("');\n\n");
    }

    private void addCodeToRequireGoogModules(SoyFileNode soyFile) {
        int counter = 1;
        HashSet<String> calls = new HashSet<String>();
        for (CallBasicNode callNode : SoyTreeUtils.getAllNodesOfType(soyFile, CallBasicNode.class)) {
            calls.add(callNode.getCalleeName());
        }
        TreeMultimap<String, String> namespaceToTemplates = TreeMultimap.create();
        for (String call : calls) {
            namespaceToTemplates.put(call.substring(0, call.lastIndexOf(46)), call);
        }
        for (String namespace : namespaceToTemplates.keySet()) {
            if (namespace.equals(soyFile.getNamespace())) continue;
            String namespaceAlias = "$import" + counter++;
            String importNamespace = this.getGoogModuleNamespace(namespace);
            this.jsCodeBuilder.appendLine("var ", namespaceAlias, " = goog.require('", importNamespace, "');");
            for (String fullyQualifiedName : namespaceToTemplates.get((Object)namespace)) {
                String alias = this.templateAliases.get(fullyQualifiedName);
                String shortName = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46));
                this.jsCodeBuilder.appendLine("var ", alias, " = ", namespaceAlias, shortName, ";");
            }
        }
    }

    private static void addCodeToProvideJsFunctions(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> templateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            templateNames.add(template.getTemplateName());
        }
        for (String templateName : templateNames) {
            header.append("goog.provide('").append(templateName).append("');\n");
        }
    }

    private void addJsDocToProvideDelTemplates(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            if (!(template instanceof TemplateDelegateNode)) continue;
            delTemplateNames.add(this.delTemplateNamer.getDelegateName((TemplateDelegateNode)template));
        }
        for (String delTemplateName : delTemplateNames) {
            header.append(" * @hassoydeltemplate {").append(delTemplateName).append("}\n");
        }
    }

    private void addJsDocToRequireDelTemplates(StringBuilder header, SoyFileNode soyFile) {
        TreeSet<String> delTemplateNames = new TreeSet<String>();
        for (CallDelegateNode delCall : SoyTreeUtils.getAllNodesOfType(soyFile, CallDelegateNode.class)) {
            delTemplateNames.add(this.delTemplateNamer.getDelegateName(delCall));
        }
        for (String delTemplateName : delTemplateNames) {
            header.append(" * @hassoydelcall {").append(delTemplateName).append("}\n");
        }
    }

    protected void addCodeToRequireGeneralDeps(SoyFileNode soyFile) {
        this.jsCodeBuilder.addGoogRequire("soy", true);
        this.jsCodeBuilder.addGoogRequire("soydata", true);
        SortedSet<Object> requiredObjectTypes = ImmutableSortedSet.of();
        if (this.hasStrictParams(soyFile)) {
            requiredObjectTypes = this.getRequiredObjectTypes(soyFile);
            this.jsCodeBuilder.addGoogRequire("soy.asserts", false);
        }
        if (this.jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir()) {
            this.jsCodeBuilder.addGoogRequire(GOOG_IS_RTL_NAMESPACE, true);
        }
        if (SoyTreeUtils.hasNodesOfType(soyFile, MsgPluralNode.class, MsgSelectNode.class)) {
            this.jsCodeBuilder.addGoogRequire(GOOG_MESSAGE_FORMAT_NAMESPACE, false);
        }
        if (SoyTreeUtils.hasNodesOfType(soyFile, XidNode.class)) {
            this.jsCodeBuilder.addGoogRequire("xid", false);
        }
        TreeSet<String> pluginRequiredJsLibNames = new TreeSet<String>();
        pluginRequiredJsLibNames.addAll(this.genDirectivePluginRequiresVisitor.exec(soyFile));
        pluginRequiredJsLibNames.addAll(new GenFunctionPluginRequiresVisitor().exec(soyFile));
        for (String string : pluginRequiredJsLibNames) {
            this.jsCodeBuilder.addGoogRequire(string, false);
        }
        if (!requiredObjectTypes.isEmpty()) {
            for (String string : requiredObjectTypes) {
                this.jsCodeBuilder.addGoogRequire(string, false);
            }
        }
    }

    private void addCodeToRequireSoyNamespaces(SoyFileNode soyFile) {
        String prevCalleeNamespace = null;
        TreeSet<String> calleeNamespaces = new TreeSet<String>();
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            String calleeNotInFile = node.getCalleeName();
            int lastDotIndex = calleeNotInFile.lastIndexOf(46);
            if (lastDotIndex == -1) {
                this.errorReporter.report(node.getSourceLocation(), NON_NAMESPACED_TEMPLATE, new Object[0]);
                continue;
            }
            calleeNamespaces.add(calleeNotInFile.substring(0, lastDotIndex));
        }
        for (String calleeNamespace : calleeNamespaces) {
            if (calleeNamespace.length() <= 0 || calleeNamespace.equals(prevCalleeNamespace)) continue;
            this.jsCodeBuilder.addGoogRequire(calleeNamespace, false);
            prevCalleeNamespace = calleeNamespace;
        }
    }

    private void addCodeToRequireJsFunctions(SoyFileNode soyFile) {
        TreeSet<String> requires = new TreeSet<String>();
        for (CallBasicNode node : new FindCalleesNotInFileVisitor().exec(soyFile)) {
            requires.add(node.getCalleeName());
        }
        for (String require : requires) {
            this.jsCodeBuilder.addGoogRequire(require, false);
        }
    }

    protected String getTemplateReturnType(TemplateNode node) {
        return node.getContentKind() == null ? "string" : "!" + NodeContentKinds.toJsSanitizedContentReturnType(node.getContentKind());
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        boolean useStrongTyping = this.hasStrictParams(node);
        String templateName = node.getTemplateName();
        String partialName = node.getPartialTemplateName();
        boolean addToExports = this.jsSrcOptions.shouldGenerateGoogModules();
        String alias = addToExports && node instanceof TemplateDelegateNode ? node.getPartialTemplateName().substring(1) : this.templateAliases.get(templateName);
        UniqueNameGenerator nameGenerator = JsSrcNameGenerators.forLocalVariables();
        CodeChunk.Generator codeGenerator = CodeChunk.Generator.create(nameGenerator);
        this.templateTranslationContext = TranslationContext.of(SoyToJsVariableMappings.forNewTemplate(), codeGenerator, nameGenerator);
        this.genJsExprsVisitor = this.genJsExprsVisitorFactory.create(this.templateTranslationContext, this.templateAliases, this.errorReporter);
        this.assistantForMsgs = null;
        String paramsRecordType = null;
        if (this.jsSrcOptions.shouldGenerateJsdoc()) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.append(" * @param {");
            if (useStrongTyping) {
                paramsRecordType = this.genParamsRecordType(node);
                this.jsCodeBuilder.append(paramsRecordType);
            } else {
                this.jsCodeBuilder.append("Object<string, *>=");
            }
            this.jsCodeBuilder.appendLine("} opt_data");
            this.jsCodeBuilder.appendLine(" * @param {(null|undefined)=} opt_ignored");
            this.jsCodeBuilder.appendLine(" * @param {Object<string, *>=} opt_ijData");
            String returnType = this.getTemplateReturnType(node);
            this.jsCodeBuilder.appendLine(" * @return {", returnType, "}");
            String suppressions = "checkTypes";
            this.jsCodeBuilder.appendLine(" * @suppress {" + suppressions + "}");
            if (node.getVisibility() == Visibility.PRIVATE) {
                this.jsCodeBuilder.appendLine(" * @private");
            }
            this.jsCodeBuilder.appendLine(" */");
        }
        if (addToExports) {
            this.jsCodeBuilder.appendLine("function ", alias, "(opt_data, opt_ignored, opt_ijData) {");
        } else {
            this.jsCodeBuilder.appendLine(alias, " = function(opt_data, opt_ignored, opt_ijData) {");
        }
        this.jsCodeBuilder.increaseIndent();
        if (!SoyTreeUtils.getAllNodesOfType(node, OperatorNodes.NullCoalescingOpNode.class).isEmpty() || !SoyTreeUtils.getAllNodesOfType(node, SwitchNode.class).isEmpty()) {
            this.jsCodeBuilder.appendLine("var $$temp;");
        }
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            this.jsCodeBuilder.appendLine("opt_data = opt_data || {};");
        }
        if (GenJsCodeVisitor.shouldEnsureIjDataIsDefined(node)) {
            this.jsCodeBuilder.appendLine("opt_ijData = opt_ijData || {};");
        }
        this.generateFunctionBody(node);
        this.jsCodeBuilder.decreaseIndent();
        if (addToExports) {
            this.jsCodeBuilder.appendLine("}");
            this.jsCodeBuilder.appendLine("exports.", partialName.substring(1), " = ", alias, ";");
        } else {
            this.jsCodeBuilder.appendLine("};");
        }
        if (paramsRecordType != null) {
            this.jsCodeBuilder.appendLine("/**");
            this.jsCodeBuilder.appendLine(" * @typedef {", paramsRecordType, "}");
            this.jsCodeBuilder.appendLine(" */");
            this.jsCodeBuilder.appendLine(alias + ".Params;");
        }
        this.jsCodeBuilder.appendLine("if (goog.DEBUG) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine(alias + ".soyTemplateName = '" + templateName + "';");
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
        if (node instanceof TemplateDelegateNode) {
            TemplateDelegateNode nodeAsDelTemplate = (TemplateDelegateNode)node;
            String delTemplateIdExprText = "soy.$$getDelTemplateId('" + this.delTemplateNamer.getDelegateName(nodeAsDelTemplate) + "')";
            String delTemplateVariantExprText = "'" + nodeAsDelTemplate.getDelTemplateVariant() + "'";
            this.jsCodeBuilder.appendLine("soy.$$registerDelegateFn(", delTemplateIdExprText, ", ", delTemplateVariantExprText, ", ", nodeAsDelTemplate.getDelPriority().toString(), ", ", alias, ");");
        }
    }

    private static boolean shouldEnsureIjDataIsDefined(TemplateNode node) {
        for (VarRefNode ref : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (ref.isDollarSignIjParameter()) {
                if (!ref.getName().equals("csp_nonce")) continue;
                return true;
            }
            if (!ref.getDefnDecl().isInjected() || ref.getDefnDecl().kind() != VarDefn.Kind.PARAM) continue;
            return false;
        }
        return false;
    }

    protected void generateFunctionBody(TemplateNode node) {
        CodeChunk.WithValue templateBody;
        this.genParamTypeChecks(node);
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            List<CodeChunk.WithValue> templateBodyChunks = this.genJsExprsVisitor.exec(node);
            templateBody = node.getContentKind() == null ? CodeChunkUtils.concatChunksForceString(templateBodyChunks) : CodeChunkUtils.concatChunks(templateBodyChunks);
        } else {
            this.jsCodeBuilder.pushOutputVar("output");
            this.visitChildren(node);
            templateBody = CodeChunk.id("output");
            this.jsCodeBuilder.popOutputVar();
        }
        if (node.getContentKind() != null) {
            templateBody = CodeChunkUtils.wrapAsSanitizedContent(node.getContentKind(), templateBody, false);
        }
        this.jsCodeBuilder.append(CodeChunk.return_(templateBody));
    }

    protected GenJsCodeVisitorAssistantForMsgs getAssistantForMsgs() {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new GenJsCodeVisitorAssistantForMsgs(this, this.jsSrcOptions, this.jsExprTranslator, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter);
        }
        return this.assistantForMsgs;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        throw new AssertionError((Object)"Inconceivable! LetContentNode should catch this directly.");
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        String generatedVarName = node.getUniqueVarName();
        CodeChunk.WithValue value = this.jsExprTranslator.translateToCodeChunk(node.getValueExpr(), this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.append(CodeChunk.declare(generatedVarName, value));
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(generatedVarName));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        if (node.getChildren().size() == 1 && node.getChild(0) instanceof MsgFallbackGroupNode) {
            String msgVar = this.getAssistantForMsgs().generateMsgGroupVariable((MsgFallbackGroupNode)node.getChild(0));
            this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(msgVar));
            return;
        }
        String generatedVarName = node.getUniqueVarName();
        this.jsCodeBuilder.pushOutputVar(generatedVarName);
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
        if (node.getContentKind() != null) {
            String sanitizedContentOrdainer = NodeContentKinds.toJsSanitizedContentOrdainerForInternalBlocks(node.getContentKind());
            this.jsCodeBuilder.appendLine(generatedVarName, " = ", sanitizedContentOrdainer, "(", generatedVarName, ");");
        }
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(generatedVarName));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
        } else {
            this.generateNonExpressionIfNode(node);
        }
    }

    protected void generateNonExpressionIfNode(IfNode node) {
        ConditionalBuilder conditional = null;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                CodeChunk.WithValue predicate = this.jsExprTranslator.translateToCodeChunk(((IfCondNode)child).getExprUnion(), this.templateTranslationContext, this.errorReporter);
                JsCodeBuilder originalCodeBuilder = this.jsCodeBuilder;
                this.jsCodeBuilder = this.createChildJsCodeBuilder();
                this.jsCodeBuilder.increaseIndent();
                this.visit(child);
                this.jsCodeBuilder.decreaseIndent();
                CodeChunk consequent = this.jsCodeBuilder.getCodeAsChunkLegacyOnly();
                originalCodeBuilder.setIndent(this.jsCodeBuilder.getIndent());
                this.jsCodeBuilder = originalCodeBuilder;
                if (conditional == null) {
                    conditional = this.templateTranslationContext.codeGenerator().newChunk().if_(predicate, consequent);
                    continue;
                }
                conditional.elseif_(predicate, consequent);
                continue;
            }
            if (child instanceof IfElseNode) {
                JsCodeBuilder originalCodeBuilder = this.jsCodeBuilder;
                this.jsCodeBuilder = this.createChildJsCodeBuilder();
                this.jsCodeBuilder.increaseIndent();
                this.visit(child);
                this.jsCodeBuilder.decreaseIndent();
                CodeChunk trailingElse = this.jsCodeBuilder.getCodeAsChunkLegacyOnly();
                originalCodeBuilder.setIndent(this.jsCodeBuilder.getIndent());
                this.jsCodeBuilder = originalCodeBuilder;
                conditional.else_(trailingElse);
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.append(conditional.endif().build());
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        String switchExpr = this.coerceTypeForSwitchComparison(node.getExpr(), node.getExprText());
        this.jsCodeBuilder.appendLine("switch (", switchExpr, ") {");
        this.jsCodeBuilder.increaseIndent();
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprNode exprNode : scn.getExprList()) {
                    JsExpr caseJsExpr = this.jsExprTranslator.translateToCodeChunk(exprNode, this.templateTranslationContext, this.errorReporter).assertExpr();
                    this.jsCodeBuilder.appendLine("case ", caseJsExpr.getText(), ":");
                }
                this.jsCodeBuilder.increaseIndent();
                this.visit(scn);
                this.jsCodeBuilder.appendLine("break;");
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                SwitchDefaultNode sdn = (SwitchDefaultNode)child;
                this.jsCodeBuilder.appendLine("default:");
                this.jsCodeBuilder.increaseIndent();
                this.visit(sdn);
                this.jsCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    private String coerceTypeForSwitchComparison(ExprRootNode v2Expr, String v1Expr) {
        String jsExpr = this.jsExprTranslator.translateToCodeChunk(v2Expr, v1Expr, this.templateTranslationContext, this.errorReporter).assertExpr().getText();
        SoyType type = v2Expr.getType();
        if (SoyTypes.makeNullable(StringType.getInstance()).isAssignableFrom(type) || type.equals(AnyType.getInstance()) || type.equals(UnknownType.getInstance())) {
            return "(goog.isObject($$temp = " + jsExpr + ")) ? $$temp.toString() : $$temp";
        }
        return jsExpr;
    }

    @Override
    protected void visitForeachNode(ForeachNode node) {
        boolean hasIfemptyNode;
        ForeachNonemptyNode nonEmptyNode = (ForeachNonemptyNode)node.getChild(0);
        String baseVarName = nonEmptyNode.getVarName();
        String nodeId = Integer.toString(node.getId());
        String listVarName = baseVarName + "List" + nodeId;
        String listLenVarName = baseVarName + "ListLen" + nodeId;
        CodeChunk.WithValue dataRef = this.jsExprTranslator.translateToCodeChunk(node.getExpr(), node.getExprText(), this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.append(CodeChunk.declare(listVarName, dataRef));
        this.jsCodeBuilder.appendLine("var ", listLenVarName, " = ", listVarName, ".length;");
        boolean bl = hasIfemptyNode = node.numChildren() == 2;
        if (hasIfemptyNode) {
            this.jsCodeBuilder.appendLine("if (", listLenVarName, " > 0) {").increaseIndent();
        }
        this.visit(nonEmptyNode);
        if (hasIfemptyNode) {
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("} else {").increaseIndent();
            this.visit((SoyNode)node.getChild(1));
            this.jsCodeBuilder.decreaseIndent();
            this.jsCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        String baseVarName = node.getVarName();
        String foreachNodeId = Integer.toString(node.getForeachNodeId());
        String listVarName = baseVarName + "List" + foreachNodeId;
        String listLenVarName = baseVarName + "ListLen" + foreachNodeId;
        String indexVarName = baseVarName + "Index" + foreachNodeId;
        String dataVarName = baseVarName + "Data" + foreachNodeId;
        this.jsCodeBuilder.appendLine("for (var ", indexVarName, " = 0; ", indexVarName, " < ", listLenVarName, "; ", indexVarName, "++) {");
        this.jsCodeBuilder.increaseIndent();
        this.jsCodeBuilder.appendLine("var ", dataVarName, " = ", listVarName, "[", indexVarName, "];");
        this.templateTranslationContext.soyToJsVariableMappings().put(baseVarName, CodeChunk.id(dataVarName)).put(baseVarName + "__isFirst", CodeChunk.id(indexVarName).doubleEquals(CodeChunk.number(0L))).put(baseVarName + "__isLast", CodeChunk.id(indexVarName).doubleEquals(CodeChunk.id(listLenVarName).minus(CodeChunk.number(1L)))).put(baseVarName + "__index", CodeChunk.id(indexVarName));
        this.visitChildren(node);
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitForNode(ForNode node) {
        String incrementCode;
        String limitCode;
        String initCode;
        String varName = node.getVarName();
        String nodeId = Integer.toString(node.getId());
        ForNode.RangeArgs range = node.getRangeArgs();
        String incrementJsExprText = range.increment().isPresent() ? this.jsExprTranslator.translateToCodeChunk(range.increment().get(), this.templateTranslationContext, this.errorReporter).assertExpr().getText() : "1";
        String initJsExprText = range.start().isPresent() ? this.jsExprTranslator.translateToCodeChunk(range.start().get(), this.templateTranslationContext, this.errorReporter).assertExpr().getText() : "0";
        String limitJsExprText = this.jsExprTranslator.translateToCodeChunk(range.limit(), this.templateTranslationContext, this.errorReporter).assertExpr().getText();
        if (INTEGER.matcher(initJsExprText).matches()) {
            initCode = initJsExprText;
        } else {
            initCode = varName + "Init" + nodeId;
            this.jsCodeBuilder.appendLine("var ", initCode, " = ", initJsExprText, ";");
        }
        if (INTEGER.matcher(limitJsExprText).matches()) {
            limitCode = limitJsExprText;
        } else {
            limitCode = varName + "Limit" + nodeId;
            this.jsCodeBuilder.appendLine("var ", limitCode, " = ", limitJsExprText, ";");
        }
        if (INTEGER.matcher(incrementJsExprText).matches()) {
            incrementCode = incrementJsExprText;
        } else {
            incrementCode = varName + "Increment" + nodeId;
            this.jsCodeBuilder.appendLine("var ", incrementCode, " = ", incrementJsExprText, ";");
        }
        String incrementStmt = incrementCode.equals("1") ? varName + nodeId + "++" : varName + nodeId + " += " + incrementCode;
        this.jsCodeBuilder.appendLine("for (var ", varName, nodeId, " = ", initCode, "; ", varName, nodeId, " < ", limitCode, "; ", incrementStmt, ") {");
        this.jsCodeBuilder.increaseIndent();
        this.templateTranslationContext.soyToJsVariableMappings().put(varName, CodeChunk.id(varName + nodeId));
        this.visitChildren(node);
        this.jsCodeBuilder.decreaseIndent();
        this.jsCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter);
        this.jsCodeBuilder.addChunkToOutputVar(call);
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder.pushOutputVar("param" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder.popOutputVar();
    }

    @Override
    protected void visitLogNode(LogNode node) {
        if (this.isComputableAsJsExprsVisitor.execOnChildren(node).booleanValue()) {
            List<CodeChunk.WithValue> logMsgChunks = this.genJsExprsVisitor.execOnChildren(node);
            this.jsCodeBuilder.append(CodeChunk.dottedId("window.console.log").call(CodeChunkUtils.concatChunks(logMsgChunks)));
        } else {
            this.jsCodeBuilder.pushOutputVar("logMsg_s" + node.getId());
            this.visitChildren(node);
            this.jsCodeBuilder.popOutputVar();
            this.jsCodeBuilder.appendLine("window.console.log(logMsg_s", Integer.toString(node.getId()), ");");
        }
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
        this.jsCodeBuilder.appendLine("debugger;");
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            if (node instanceof SoyNode.BlockNode) {
                this.visitChildren((SoyNode.BlockNode)node);
            } else {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return;
        }
        if (!((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.jsCodeBuilder.addChunksToOutputVar(this.genJsExprsVisitor.exec(node));
    }

    private String genParamsRecordType(TemplateNode node) {
        HashSet<String> paramNames = new HashSet<String>();
        LinkedHashMap<String, String> record = new LinkedHashMap<String, String>();
        for (TemplateParam param : node.getParams()) {
            record.put(this.genParamAlias(param.name()), this.getJsType(param.type()).typeExprForRecordMember());
            paramNames.add(param.name());
        }
        FindIndirectParamsVisitor.IndirectParamsInfo ipi = new FindIndirectParamsVisitor(this.templateRegistry).exec(node);
        if (!ipi.mayHaveIndirectParamsInExternalCalls && !ipi.mayHaveIndirectParamsInExternalDelCalls) {
            for (String indirectParamName : ipi.indirectParamTypes.keySet()) {
                if (paramNames.contains(indirectParamName)) continue;
                Collection<SoyType> paramTypes = ipi.indirectParamTypes.get(indirectParamName);
                SoyType combinedType = this.typeOps.computeLowestCommonType(paramTypes);
                SoyType indirectParamType = this.typeOps.getTypeRegistry().getOrCreateUnionType(combinedType, NullType.getInstance());
                record.put(this.genParamAlias(indirectParamName), this.getJsType(indirectParamType).typeExprForRecordMember());
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{\n *  ");
        Joiner.on(",\n *  ").withKeyValueSeparator(": ").appendTo(sb, (Map<?, ?>)record);
        sb.append("\n * }");
        return sb.toString();
    }

    protected String getJsTypeName(SoyType type) {
        return JsSrcUtils.getJsTypeName(type);
    }

    protected void genParamTypeChecks(TemplateNode node) {
        for (TemplateParam param : node.getAllParams()) {
            Optional<CodeChunk.WithValue> typeAssertion;
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            String paramName = param.name();
            SoyType paramType = param.type();
            CodeChunk.Generator generator = this.templateTranslationContext.codeGenerator();
            CodeChunk.WithValue paramChunk = TranslateExprNodeVisitor.genCodeForParamAccess(paramName, param.isInjected());
            JsType jsType = this.getJsType(paramType);
            String paramAlias = this.genParamAlias(paramName);
            CodeChunk.WithValue coerced = jsType.getValueCoercion(paramChunk, generator);
            if (coerced != null) {
                paramChunk = generator.newChunk().assign(coerced).buildAsValue();
            }
            CodeChunk.WithValue value = (typeAssertion = jsType.getTypeAssertion(paramChunk, generator)).isPresent() ? CodeChunk.dottedId("soy.asserts.assertType").call(typeAssertion.get(), CodeChunk.stringLiteral(paramName), paramChunk, CodeChunk.stringLiteral(jsType.typeExpr())) : paramChunk;
            CodeChunk.WithValue declaration = CodeChunk.declare(this.jsSrcOptions.shouldGenerateJsdoc() ? jsType.typeExpr() : null, paramAlias, value);
            this.jsCodeBuilder.append(declaration);
            this.templateTranslationContext.soyToJsVariableMappings().put(paramName, CodeChunk.id(paramAlias));
        }
    }

    private JsType getJsType(SoyType paramType) {
        boolean isIncrementalDom = !this.getClass().equals(GenJsCodeVisitor.class);
        return JsType.forSoyType(paramType, isIncrementalDom);
    }

    private String genParamAlias(String paramName) {
        return JsSrcUtils.isReservedWord(paramName) ? "param$" + paramName : paramName;
    }

    private boolean hasStrictParams(SoyFileNode soyFile) {
        for (TemplateNode template : soyFile.getChildren()) {
            if (template.getInjectedParams().isEmpty() && !this.hasStrictParams(template)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStrictParams(TemplateNode template) {
        for (TemplateParam param : template.getParams()) {
            if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
            return true;
        }
        return false;
    }

    private SortedSet<String> getRequiredObjectTypes(SoyFileNode soyFile) {
        TreeSet<String> requiredObjectTypes = new TreeSet<String>();
        FieldImportsVisitor fieldImportsVisitor = new FieldImportsVisitor(requiredObjectTypes);
        for (TemplateNode template : soyFile.getChildren()) {
            SoyTreeUtils.execOnAllV2Exprs(template, fieldImportsVisitor);
            for (TemplateParam param : template.getAllParams()) {
                if (param.declLoc() != TemplateParam.DeclLoc.HEADER) continue;
                if (GenJsCodeVisitor.shouldGenerateGoogRequire(param.type())) {
                    requiredObjectTypes.add(this.getJsTypeName(param.type()));
                    continue;
                }
                if (param.type().getKind() != SoyType.Kind.UNION) continue;
                UnionType union = (UnionType)param.type();
                for (SoyType memberType : union.getMembers()) {
                    if (!GenJsCodeVisitor.shouldGenerateGoogRequire(memberType)) continue;
                    requiredObjectTypes.add(this.getJsTypeName(memberType));
                }
            }
        }
        for (ProtoInitNode protoInit : SoyTreeUtils.getAllNodesOfType(soyFile, ProtoInitNode.class)) {
            SoyType type = protoInit.getType();
            requiredObjectTypes.add(this.getJsTypeName(type));
        }
        return requiredObjectTypes;
    }

    private static boolean shouldGenerateGoogRequire(SoyType type) {
        return type.getKind() == SoyType.Kind.PROTO || type.getKind() == SoyType.Kind.PROTO_ENUM;
    }

    private static final class FieldImportsVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final SortedSet<String> imports;

        FieldImportsVisitor(SortedSet<String> imports) {
            this.imports = imports;
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            SoyType baseType = node.getBaseExprChild().getType();
            this.extractImportsFromType(baseType, node.getFieldName());
            this.visit(node.getBaseExprChild());
        }

        private void extractImportsFromType(SoyType baseType, String fieldName) {
            if (baseType.getKind() == SoyType.Kind.PROTO) {
                Descriptors.FieldDescriptor desc = ((SoyProtoType)baseType).getFieldDescriptor(fieldName);
                if (desc.isExtension()) {
                    this.imports.add(Protos.getJsExtensionImport(desc));
                }
                if (Protos.isSanitizedContentField(desc)) {
                    if (desc.isRepeated()) {
                        this.imports.add("goog.array");
                    }
                    this.imports.add(NodeContentKinds.toJsUnpackFunction(desc.getMessageType()));
                }
            } else if (baseType.getKind() == SoyType.Kind.UNION) {
                for (SoyType memberBaseType : ((UnionType)baseType).getMembers()) {
                    this.extractImportsFromType(memberBaseType, fieldName);
                }
            }
        }
    }
}

