/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

final class AssertStrictAutoescapingVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind INVALID_AUTOESCAPING = SoyErrorKind.of("Invalid use of non-strict when strict autoescaping is required.");
    private final ErrorReporter errorReporter;

    AssertStrictAutoescapingVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument(soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode);
        super.exec(soyNode);
        return null;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        NamespaceDeclaration namespaceDeclaration = node.getNamespaceDeclaration();
        if (namespaceDeclaration.getDefaultAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(namespaceDeclaration.getAutoescapeModeLocation(), INVALID_AUTOESCAPING, new Object[0]);
            return;
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getAutoescapeMode() != AutoescapeMode.STRICT) {
            this.errorReporter.report(node.getSourceLocation(), INVALID_AUTOESCAPING, new Object[0]);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

