/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;

@VisibleForTesting
public final class ResolveFunctionsVisitor
extends AbstractExprNodeVisitor<Void> {
    private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;

    public ResolveFunctionsVisitor(ImmutableMap<String, ? extends SoyFunction> soyFunctionMap) {
        this.soyFunctionMap = soyFunctionMap;
    }

    @Override
    protected void visitFunctionNode(FunctionNode node) {
        String functionName = node.getFunctionName();
        SoyFunction function = this.soyFunctionMap.get(functionName);
        if (function != null) {
            node.setSoyFunction(function);
        } else {
            function = BuiltinFunction.forFunctionName(functionName);
            if (function != null) {
                node.setSoyFunction(function);
            }
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitExprNode(ExprNode node) {
        if (node instanceof ExprNode.ParentExprNode) {
            this.visitChildren((ExprNode.ParentExprNode)node);
        }
    }
}

