/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

final class PyCodeBuilder {
    private static final int INDENT_SIZE = 2;
    private final StringBuilder code = new StringBuilder();
    private String indent = "";
    private final Deque<Pair<String, Boolean>> outputVars = new ArrayDeque<Pair<String, Boolean>>();
    private String currOutputVarName = null;
    private boolean currOutputVarIsInited = false;

    PyCodeBuilder() {
    }

    void initOutputVarIfNecessary() {
        if (this.getOutputVarIsInited()) {
            return;
        }
        this.appendLine(this.getOutputVarName(), " = []");
        this.setOutputVarInited();
    }

    void addToOutputVar(List<? extends PyExpr> pyExprs) {
        this.addToOutputVar(PyExprUtils.concatPyExprs(pyExprs));
    }

    void addToOutputVar(PyExpr pyExpr) {
        boolean isList = pyExpr instanceof PyListExpr;
        if (isList && !this.getOutputVarIsInited()) {
            this.appendLine(this.getOutputVarName(), " = ", pyExpr.getText());
        } else {
            this.initOutputVarIfNecessary();
            String function = isList ? ".extend(" : ".append(";
            this.appendLine(this.getOutputVarName(), function, pyExpr.getText(), ")");
        }
        this.setOutputVarInited();
    }

    PyStringExpr getOutputAsString() {
        Preconditions.checkState(this.getOutputVarName() != null);
        this.initOutputVarIfNecessary();
        return new PyListExpr(this.getOutputVarName(), Integer.MAX_VALUE).toPyString();
    }

    void increaseIndent() {
        this.changeIndentHelper(1);
    }

    void increaseIndentTwice() {
        this.changeIndentHelper(2);
    }

    public void decreaseIndent() {
        this.changeIndentHelper(-1);
    }

    void decreaseIndentTwice() {
        this.changeIndentHelper(-2);
    }

    private void changeIndentHelper(int chg) {
        int newIndentDepth = this.indent.length() + chg * 2;
        Preconditions.checkState(newIndentDepth >= 0);
        this.indent = Strings.repeat(" ", newIndentDepth);
    }

    public void pushOutputVar(String outputVarName) {
        this.outputVars.push(Pair.of(outputVarName, false));
        this.currOutputVarName = outputVarName;
        this.currOutputVarIsInited = false;
    }

    void popOutputVar() {
        this.outputVars.pop();
        Pair<String, Boolean> topPair = this.outputVars.peek();
        if (topPair != null) {
            this.currOutputVarName = (String)topPair.first;
            this.currOutputVarIsInited = (Boolean)topPair.second;
        } else {
            this.currOutputVarName = null;
            this.currOutputVarIsInited = false;
        }
    }

    void setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(Pair.of(this.currOutputVarName, true));
        this.currOutputVarIsInited = true;
    }

    String getOutputVarName() {
        return this.currOutputVarName;
    }

    public PyCodeBuilder append(String ... codeFragments) {
        for (String codeFragment : codeFragments) {
            this.code.append(codeFragment);
        }
        return this;
    }

    public PyCodeBuilder appendLine(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    public PyCodeBuilder appendLineStart(String ... codeFragments) {
        this.code.append(this.indent);
        this.append(codeFragments);
        return this;
    }

    public PyCodeBuilder appendLineEnd(String ... codeFragments) {
        this.append(codeFragments);
        this.code.append("\n");
        return this;
    }

    PyCodeBuilder appendOutputVarName() {
        this.code.append(this.currOutputVarName);
        return this;
    }

    public String getCode() {
        return this.code.toString();
    }

    boolean getOutputVarIsInited() {
        return this.currOutputVarIsInited;
    }
}

