/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyFunction;
import java.util.Map;
import java.util.Set;

public enum BuiltinFunction implements SoyFunction
{
    IS_FIRST,
    IS_LAST,
    INDEX,
    QUOTE_KEYS_IF_JS,
    CHECK_NOT_NULL;

    private static final Map<String, BuiltinFunction> NONPLUGIN_FUNCTIONS_BY_NAME;
    private final String functionName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());

    public static BuiltinFunction forFunctionName(String functionName) {
        return NONPLUGIN_FUNCTIONS_BY_NAME.get(functionName);
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of(Integer.valueOf(1));
    }

    static {
        ImmutableMap.Builder<String, BuiltinFunction> mapBuilder = ImmutableMap.builder();
        for (BuiltinFunction nonpluginFn : BuiltinFunction.values()) {
            mapBuilder.put(nonpluginFn.functionName, nonpluginFn);
        }
        NONPLUGIN_FUNCTIONS_BY_NAME = mapBuilder.build();
    }
}

