/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;

public final class HtmlCloseTagNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode,
SoyNode.BlockNode {
    private final TagName tagName;

    public HtmlCloseTagNode(int id, TagName tagName, SourceLocation sourceLocation) {
        super(id, sourceLocation);
        this.tagName = Preconditions.checkNotNull(tagName);
    }

    private HtmlCloseTagNode(HtmlCloseTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.tagName = orig.tagName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_CLOSE_TAG_NODE;
    }

    public TagName getTagName() {
        return this.tagName;
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public HtmlCloseTagNode copy(CopyState copyState) {
        return new HtmlCloseTagNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("</").append(this.getTagName());
        for (SoyNode.StandaloneNode child : this.getChildren()) {
            sb.append(" ").append(child.toSourceString());
        }
        sb.append(">");
        return sb.toString();
    }
}

