/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;

public final class HtmlOpenTagNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode,
SoyNode.BlockNode {
    private final boolean selfClosing;
    private final TagName tagName;

    public HtmlOpenTagNode(int id, TagName tagName, SourceLocation sourceLocation, boolean selfClosing) {
        super(id, sourceLocation);
        this.tagName = Preconditions.checkNotNull(tagName);
        this.selfClosing = selfClosing;
    }

    private HtmlOpenTagNode(HtmlOpenTagNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selfClosing = orig.selfClosing;
        this.tagName = orig.tagName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_OPEN_TAG_NODE;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public TagName getTagName() {
        return this.tagName;
    }

    @Override
    public HtmlOpenTagNode copy(CopyState copyState) {
        return new HtmlOpenTagNode(this, copyState);
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getTagName());
        for (SoyNode.StandaloneNode child : this.getChildren()) {
            sb.append(" ").append(child.toSourceString());
        }
        sb.append(this.selfClosing ? "/>" : ">");
        return sb.toString();
    }
}

