/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import javax.annotation.Nullable;

final class RequirecssUtils {
    private RequirecssUtils() {
    }

    static ImmutableList<String> parseRequirecssAttr(@Nullable String requirecssAttr, SourceLocation srcLoc) {
        String[] namespaces;
        if (requirecssAttr == null) {
            return ImmutableList.of();
        }
        for (String namespace : namespaces = requirecssAttr.trim().split("\\s*,\\s*")) {
            if (BaseUtils.isDottedIdentifier(namespace)) continue;
            throw LegacyInternalSyntaxException.createWithMetaInfo("Invalid required CSS namespace name \"" + namespace + "\".", srcLoc);
        }
        return ImmutableList.copyOf(namespaces);
    }
}

