/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Date;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ChannelExec
extends PtyCapableChannelSession {
    public static final String REQUEST_EXEC_REPLY = "channel-exec-want-reply";
    public static final boolean DEFAULT_REQUEST_EXEC_REPLY = false;
    private final String command;

    public ChannelExec(String command) {
        super(false);
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "Command may not be null/empty");
    }

    @Override
    protected void doOpen() throws IOException {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST exec command={}", (Object)this, (Object)this.command);
        }
        Session session = this.getSession();
        boolean wantReply = PropertyResolverUtils.getBooleanProperty(this, REQUEST_EXEC_REPLY, false);
        Buffer buffer = session.createBuffer((byte)98, this.command.length() + 32);
        buffer.putInt(this.getRecipient());
        buffer.putString("exec");
        buffer.putBoolean(wantReply);
        buffer.putString(this.command);
        this.addPendingRequest("exec", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}, command={}", this, pending, this.command);
        }
    }

    @Override
    public void handleFailure() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (pending != null) {
            this.log.warn("handleFailure({}) pending since={}, command={}", this, pending, this.command);
            this.close(true);
        }
    }
}

