/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;

public class SignatureEd25519
extends AbstractSignature {
    public SignatureEd25519() {
        super("ed25519-sha-512");
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        byte[] data = sig;
        Pair<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = encoding.getFirst();
            ValidateUtils.checkTrue("ssh-ed25519".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = encoding.getSecond();
        }
        return this.doVerify(data);
    }
}

