/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.Rule;
import org.parboiled.matchers.VarFramingMatcher;
import org.parboiled.support.Var;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class VarFramingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return !method.getLocalVarVariables().isEmpty();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        instructions.insertBefore(ret, new TypeInsnNode(187, CodegenUtils.p(VarFramingMatcher.class)));
        instructions.insertBefore(ret, new InsnNode(90));
        instructions.insertBefore(ret, new InsnNode(95));
        VarFramingGenerator.createVarFieldArray(method, instructions, ret);
        instructions.insertBefore(ret, new MethodInsnNode(183, CodegenUtils.p(VarFramingMatcher.class), "<init>", CodegenUtils.sig(Void.TYPE, Rule.class, Var[].class), false));
        method.setBodyRewritten();
    }

    private static void createVarFieldArray(RuleMethod method, InsnList instructions, AbstractInsnNode ret) {
        int count = method.getLocalVarVariables().size();
        instructions.insertBefore(ret, new IntInsnNode(16, count));
        instructions.insertBefore(ret, new TypeInsnNode(189, CodegenUtils.p(Var.class)));
        for (int i = 0; i < count; ++i) {
            LocalVariableNode var = method.getLocalVarVariables().get(i);
            instructions.insertBefore(ret, new InsnNode(89));
            instructions.insertBefore(ret, new IntInsnNode(16, i));
            instructions.insertBefore(ret, new VarInsnNode(25, var.index));
            instructions.insertBefore(ret, new InsnNode(89));
            instructions.insertBefore(ret, new LdcInsnNode(method.name + ':' + var.name));
            instructions.insertBefore(ret, new MethodInsnNode(182, CodegenUtils.p(Var.class), "setName", CodegenUtils.sig(Void.TYPE, String.class), false));
            instructions.insertBefore(ret, new InsnNode(83));
        }
    }
}

