/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Joiner;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyles;
import com.google.common.html.types.SafeUrls;
import com.google.common.html.types.escape.PercentEscaper;
import com.google.errorprone.annotations.CompileTimeConstant;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@GwtCompatible
public final class SafeStyleBuilder {
    private static final String INNOCUOUS_PROPERTY_STRING = "zJSafeHtmlzinvalid";
    private final LinkedHashMap<String, String> properties = new LinkedHashMap();
    private static final String UNRESERVED_CHARACTERS = "-._~";
    private static final String RESERVED_CHARACTERS_BACKGROUND_IMAGE = "/:?#[]@!$&*+=";
    private static final String OTHER_CHARACTERS = "%";
    private static final PercentEscaper ESCAPER_BACKGROUND_IMAGE = new PercentEscaper("-._~/:?#[]@!$&*+=%", false);
    private static final Joiner.MapJoiner JOINER = Joiner.on(";").withKeyValueSeparator(":");

    public SafeStyleBuilder backgroundAttachmentAppend(String value, String ... otherValues) {
        this.appendToProperty("background-attachment", SafeStyleBuilder.sanitizeAndJoinEnumValues(value, otherValues));
        return this;
    }

    public SafeStyleBuilder backgroundColorFromConstant(@CompileTimeConstant String constant) {
        this.properties.put("background-color", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder backgroundColor(String value) {
        this.properties.put("background-color", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundImageAppendConstant(@CompileTimeConstant String constant) {
        this.appendToProperty("background-image", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder backgroundImageAppendUrl(String url) {
        url = SafeUrls.sanitize(url).getSafeUrlString();
        try {
            url = ESCAPER_BACKGROUND_IMAGE.escape(url);
        }
        catch (IllegalArgumentException e) {
            url = INNOCUOUS_PROPERTY_STRING;
        }
        String urlValue = "url(" + url + ")";
        this.appendToProperty("background-image", urlValue);
        return this;
    }

    public SafeStyleBuilder backgroundSizeAppend(String value, String ... otherValues) {
        this.appendToProperty("background-size", SafeStyleBuilder.sanitizeAndJoinRegularValues(value, otherValues));
        return this;
    }

    public SafeStyleBuilder border(String value) {
        this.properties.put("border", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder bottom(String value) {
        this.properties.put("bottom", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder padding(String value) {
        this.properties.put("padding", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder margin(String value) {
        this.properties.put("margin", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder display(String value) {
        this.properties.put("display", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundRepeat(String value) {
        this.properties.put("background-repeat", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderColorFromConstant(@CompileTimeConstant String constant) {
        this.properties.put("border-color", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder borderColor(String value) {
        this.properties.put("border-color", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder color(String value) {
        this.properties.put("color", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder fontFamilyAppend(String value, String ... otherValues) {
        this.sanitizeAndAppendToFontFamily(value);
        for (String otherValue : otherValues) {
            this.sanitizeAndAppendToFontFamily(otherValue);
        }
        return this;
    }

    private void sanitizeAndAppendToFontFamily(String value) {
        if (SafeStyleBuilder.isEnumValue(value)) {
            this.appendToProperty("font-family", value);
        } else if (SafeStyleBuilder.isRegularValue(value)) {
            this.appendToProperty("font-family", "\"" + value + "\"");
        } else {
            this.appendToProperty("font-family", INNOCUOUS_PROPERTY_STRING);
        }
    }

    public SafeStyleBuilder height(String value) {
        this.properties.put("height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundPosition(String value) {
        this.properties.put("background-position", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder left(String value) {
        this.properties.put("left", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder lineHeight(String value) {
        this.properties.put("line-height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder overflow(String value) {
        this.properties.put("overflow", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder overflowX(String value) {
        this.properties.put("overflow-x", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder overflowY(String value) {
        this.properties.put("overflow-y", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder right(String value) {
        this.properties.put("right", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder top(String value) {
        this.properties.put("top", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder width(String value) {
        this.properties.put("width", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyle build() {
        StringBuilder sb = new StringBuilder();
        if (!this.properties.isEmpty()) {
            JOINER.appendTo(sb, (Map<?, ?>)this.properties).append(";");
        }
        return SafeStyles.create(sb.toString());
    }

    private void appendToProperty(String property, String safeValue) {
        if (this.properties.containsKey(property)) {
            this.properties.put(property, this.properties.get(property) + "," + safeValue);
        } else {
            this.properties.put(property, safeValue);
        }
    }

    private static String checkConstantValue(@CompileTimeConstant String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '<' || c == '>' || c == '\"' || c == '\'' || c == ';') {
                throw new IllegalArgumentException("Value contains HTML/CSS meta-characters ([<>\"';]): " + value);
            }
            if (!value.startsWith("/*", i) && !value.startsWith("*/", i) && !value.startsWith("//", i)) continue;
            throw new IllegalArgumentException("Value contains CSS comment marker (/*, */ or //): " + value);
        }
        return value;
    }

    private static String sanitizeAndJoinEnumValues(String value, String[] otherValues) {
        StringBuilder sb = new StringBuilder(SafeStyleBuilder.sanitizeEnumValue(value));
        for (int i = 0; i < otherValues.length; ++i) {
            sb.append(',').append(SafeStyleBuilder.sanitizeEnumValue(otherValues[i]));
        }
        return sb.toString();
    }

    private static String sanitizeAndJoinRegularValues(String value, String[] otherValues) {
        StringBuilder sb = new StringBuilder(SafeStyleBuilder.sanitizeRegularValue(value));
        for (int i = 0; i < otherValues.length; ++i) {
            sb.append(',').append(SafeStyleBuilder.sanitizeRegularValue(otherValues[i]));
        }
        return sb.toString();
    }

    private static String sanitizeEnumValue(String value) {
        if (SafeStyleBuilder.isEnumValue(value)) {
            return value;
        }
        return INNOCUOUS_PROPERTY_STRING;
    }

    private static boolean isEnumValue(String value) {
        if (value.isEmpty()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static String sanitizeRegularValue(String value) {
        if (SafeStyleBuilder.isRegularValue(value)) {
            return value;
        }
        return INNOCUOUS_PROPERTY_STRING;
    }

    private static boolean isRegularValue(String value) {
        boolean hasNonWhitespace = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (value.startsWith("/*", i) || value.startsWith("*/", i) || value.startsWith("//", i)) {
                return false;
            }
            if (c == ' ' || c == '\t') continue;
            if (c == '/' || c == '*' || c == '+' || c == '-' || c == '.' || c == '!' || c == '#' || c == '%' || c == '_') {
                hasNonWhitespace = true;
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                hasNonWhitespace = true;
                continue;
            }
            return false;
        }
        return hasNonWhitespace;
    }
}

