/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.reviewdb.client.AccountGroup;

public class GroupReference
implements Comparable<GroupReference> {
    private static final String PREFIX = "group ";
    protected String uuid;
    protected String name;

    public static GroupReference forGroup(AccountGroup group) {
        return new GroupReference(group.getGroupUUID(), group.getName());
    }

    public static GroupReference forGroup(GroupDescription.Basic group) {
        return new GroupReference(group.getGroupUUID(), group.getName());
    }

    public static boolean isGroupReference(String configValue) {
        return configValue != null && configValue.startsWith(PREFIX);
    }

    @Nullable
    public static String extractGroupName(String configValue) {
        if (!GroupReference.isGroupReference(configValue)) {
            return null;
        }
        return configValue.substring(PREFIX.length()).trim();
    }

    protected GroupReference() {
    }

    public GroupReference(AccountGroup.UUID uuid, String name) {
        this.setUUID(uuid);
        this.setName(name);
    }

    public AccountGroup.UUID getUUID() {
        return this.uuid != null ? new AccountGroup.UUID(this.uuid) : null;
    }

    public void setUUID(AccountGroup.UUID newUUID) {
        this.uuid = newUUID != null ? newUUID.get() : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public int compareTo(GroupReference o) {
        return GroupReference.uuid(this).compareTo(GroupReference.uuid(o));
    }

    private static String uuid(GroupReference a) {
        return a.getUUID() != null ? a.getUUID().get() : "?";
    }

    public int hashCode() {
        return GroupReference.uuid(this).hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof GroupReference && this.compareTo((GroupReference)o) == 0;
    }

    public String toConfigValue() {
        return PREFIX + this.name;
    }

    public String toString() {
        return "Group[" + this.getName() + " / " + this.getUUID() + "]";
    }
}

