/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.StopPluginListener;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class AllRequestFilter
implements Filter {
    public static ServletModule module() {
        return new ServletModule(){

            @Override
            protected void configureServlets() {
                DynamicSet.setOf(this.binder(), AllRequestFilter.class);
                this.filter("/*", new String[0]).through(FilterProxy.class);
                this.bind(StopPluginListener.class).annotatedWith(UniqueAnnotations.create()).to(FilterProxy.class);
            }
        };
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    @Singleton
    static class FilterProxy
    implements Filter,
    StopPluginListener {
        private final DynamicSet<AllRequestFilter> filters;
        private DynamicSet<AllRequestFilter> initializedFilters;
        private FilterConfig filterConfig;

        @Inject
        FilterProxy(DynamicSet<AllRequestFilter> filters) {
            this.filters = filters;
            this.initializedFilters = new DynamicSet();
            this.filterConfig = null;
        }

        private synchronized boolean initFilterIfNeeded(AllRequestFilter filter) throws ServletException {
            boolean ret = true;
            if (this.filters.contains(filter)) {
                if (!this.initializedFilters.contains(filter)) {
                    filter.init(this.filterConfig);
                    this.initializedFilters.add(filter);
                }
            } else {
                ret = false;
            }
            return ret;
        }

        private synchronized void cleanUpInitializedFilters() {
            DynamicSet<AllRequestFilter> filtersToCleanUp = this.initializedFilters;
            this.initializedFilters = new DynamicSet();
            for (AllRequestFilter filter : filtersToCleanUp) {
                if (this.filters.contains(filter)) {
                    this.initializedFilters.add(filter);
                    continue;
                }
                filter.destroy();
            }
        }

        @Override
        public void doFilter(ServletRequest req, ServletResponse res, final FilterChain last) throws IOException, ServletException {
            final Iterator<AllRequestFilter> itr = this.filters.iterator();
            new FilterChain(){

                @Override
                public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
                    while (itr.hasNext()) {
                        AllRequestFilter filter = (AllRequestFilter)itr.next();
                        if (!initializedFilters.contains(filter) && !this.initFilterIfNeeded(filter)) continue;
                        filter.doFilter(req, res, this);
                        return;
                    }
                    last.doFilter(req, res);
                }
            }.doFilter(req, res);
        }

        @Override
        public void init(FilterConfig config) throws ServletException {
            this.filterConfig = config;
            for (AllRequestFilter f : this.filters) {
                this.initFilterIfNeeded(f);
            }
        }

        @Override
        public synchronized void destroy() {
            DynamicSet<AllRequestFilter> filtersToDestroy = this.initializedFilters;
            this.initializedFilters = new DynamicSet();
            for (AllRequestFilter filter : filtersToDestroy) {
                filter.destroy();
            }
        }

        @Override
        public void onStopPlugin(Plugin plugin) {
            this.cleanUpInitializedFilters();
        }
    }
}

