/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jgit.lib.Config;

@Singleton
public class GetUserFilter
implements Filter {
    public static final String REQ_ATTR_KEY = "User";
    private final Provider<CurrentUser> userProvider;

    @Inject
    GetUserFilter(Provider<CurrentUser> userProvider) {
        this.userProvider = userProvider;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        CurrentUser user = this.userProvider.get();
        if (user != null && user.isIdentifiedUser()) {
            IdentifiedUser who = user.asIdentifiedUser();
            if (who.getUserName() != null && !who.getUserName().isEmpty()) {
                req.setAttribute(REQ_ATTR_KEY, who.getUserName());
            } else {
                req.setAttribute(REQ_ATTR_KEY, "a/" + who.getAccountId());
            }
        }
        chain.doFilter(req, resp);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig arg0) {
    }

    public static class Module
    extends ServletModule {
        private final boolean enabled;

        @Inject
        Module(@GerritServerConfig Config cfg) {
            this.enabled = cfg.getBoolean("http", "addUserAsRequestAttribute", true);
        }

        @Override
        protected void configureServlets() {
            if (this.enabled) {
                this.filter("/*", new String[0]).through(GetUserFilter.class);
            }
        }
    }
}

