/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class RequireSslFilter
implements Filter {
    private final Provider<String> urlProvider;

    @Inject
    RequireSslFilter(@CanonicalWebUrl @Nullable Provider<String> urlProvider) {
        this.urlProvider = urlProvider;
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        if (RequireSslFilter.isSecure(req)) {
            chain.doFilter(request, response);
        } else {
            String url;
            if (RequireSslFilter.isLocalHost(req)) {
                StringBuffer b = req.getRequestURL();
                b.replace(0, b.indexOf(":"), "https");
                url = b.toString();
            } else {
                url = this.urlProvider.get() + req.getServletPath();
            }
            rsp.setStatus(301);
            rsp.setHeader("Location", url);
        }
    }

    private static boolean isSecure(HttpServletRequest req) {
        return "https".equals(req.getScheme()) || req.isSecure();
    }

    private static boolean isLocalHost(HttpServletRequest req) {
        return "localhost".equals(req.getServerName()) || "127.0.0.1".equals(req.getServerName());
    }

    public static class Module
    extends ServletModule {
        private final boolean wantSsl;

        @Inject
        Module(@Nullable @CanonicalWebUrl String canonicalUrl) {
            this.wantSsl = canonicalUrl != null && canonicalUrl.startsWith("https:");
        }

        @Override
        protected void configureServlets() {
            if (this.wantSsl) {
                this.filter("/*", new String[0]).through(RequireSslFilter.class);
            }
        }
    }
}

