/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.cache.Cache;
import com.google.gerrit.httpd.raw.ResourceServlet;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jgit.lib.Config;

@Singleton
public class SiteStaticDirectoryServlet
extends ResourceServlet {
    private static final long serialVersionUID = 1L;
    private final Path staticBase;

    @Inject
    SiteStaticDirectoryServlet(SitePaths site, @GerritServerConfig Config cfg, @Named(value="static_content") Cache<Path, ResourceServlet.Resource> cache) {
        super(cache, cfg.getBoolean("site", "refreshHeaderFooter", true));
        Path p;
        try {
            p = site.static_dir.toRealPath(new LinkOption[0]).normalize();
        }
        catch (IOException e) {
            p = site.static_dir.toAbsolutePath().normalize();
        }
        this.staticBase = p;
    }

    @Override
    protected Path getResourcePath(String pathInfo) {
        return this.staticBase.resolve(pathInfo);
    }
}

