/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.common.Version;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.server.tools.ToolsCatalog;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class ToolServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final ToolsCatalog toc;

    @Inject
    ToolServlet(ToolsCatalog toc) {
        this.toc = toc;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        ToolsCatalog.Entry ent = this.toc.get(req.getPathInfo());
        if (ent == null) {
            rsp.sendError(404);
            return;
        }
        switch (ent.getType()) {
            case FILE: {
                this.doGetFile(ent, rsp);
                break;
            }
            case DIR: {
                this.doGetDirectory(ent, req, rsp);
                break;
            }
            default: {
                rsp.sendError(404);
            }
        }
    }

    private void doGetFile(ToolsCatalog.Entry ent, HttpServletResponse rsp) throws IOException {
        byte[] tosend = ent.getBytes();
        rsp.setDateHeader("Expires", 0L);
        rsp.setHeader("Pragma", "no-cache");
        rsp.setHeader("Cache-Control", "no-cache, must-revalidate");
        rsp.setContentType("application/octet-stream");
        rsp.setContentLength(tosend.length);
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(tosend);
        }
    }

    private void doGetDirectory(ToolsCatalog.Entry ent, HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String path = "/tools/" + ent.getPath();
        Document page = HtmlDomUtil.newDocument();
        Element html = page.createElement("html");
        Element head = page.createElement("head");
        Element title = page.createElement("title");
        Element body = page.createElement("body");
        page.appendChild(html);
        html.appendChild(head);
        html.appendChild(body);
        head.appendChild(title);
        title.setTextContent("Gerrit Code Review - " + path);
        Element h1 = page.createElement("h1");
        h1.setTextContent(title.getTextContent());
        body.appendChild(h1);
        Element ul = page.createElement("ul");
        body.appendChild(ul);
        for (ToolsCatalog.Entry e : ent.getChildren()) {
            String name = e.getName();
            if (e.getType() == ToolsCatalog.Entry.Type.DIR && !name.endsWith("/")) {
                name = name + "/";
            }
            Element li = page.createElement("li");
            Element a = page.createElement("a");
            a.setAttribute("href", name);
            a.setTextContent(name);
            li.appendChild(a);
            ul.appendChild(li);
        }
        body.appendChild(page.createElement("hr"));
        Element footer = page.createElement("p");
        footer.setAttribute("style", "text-align: right; font-style: italic");
        footer.setTextContent("Powered by Gerrit Code Review " + Version.getVersion());
        body.appendChild(footer);
        byte[] tosend = HtmlDomUtil.toUTF8(page);
        if (RPCServletUtils.acceptsGzipEncoding(req)) {
            rsp.setHeader("Content-Encoding", "gzip");
            tosend = HtmlDomUtil.compress(tosend);
        }
        rsp.setDateHeader("Expires", 0L);
        rsp.setHeader("Pragma", "no-cache");
        rsp.setHeader("Cache-Control", "no-cache, must-revalidate");
        rsp.setContentType("text/html");
        rsp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        rsp.setContentLength(tosend.length);
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(tosend);
        }
    }
}

