/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;

public final class AccountGroupMemberAudit {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Account.Id addedBy;
    @Column(id=3, notNull=false)
    protected Account.Id removedBy;
    @Column(id=4, notNull=false)
    protected Timestamp removedOn;

    protected AccountGroupMemberAudit() {
    }

    public AccountGroupMemberAudit(AccountGroupMember m, Account.Id adder, Timestamp addedOn) {
        Account.Id who = m.getAccountId();
        AccountGroup.Id group = m.getAccountGroupId();
        this.key = new Key(who, group, addedOn);
        this.addedBy = adder;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isActive() {
        return this.removedOn == null;
    }

    public void removed(Account.Id deleter, Timestamp when) {
        this.removedBy = deleter;
        this.removedOn = when;
    }

    public void removedLegacy() {
        this.removedBy = this.addedBy;
        this.removedOn = this.key.addedOn;
    }

    public Account.Id getAddedBy() {
        return this.addedBy;
    }

    public Account.Id getRemovedBy() {
        return this.removedBy;
    }

    public Timestamp getRemovedOn() {
        return this.removedOn;
    }

    public static class Key
    extends CompoundKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Account.Id accountId;
        @Column(id=2)
        protected AccountGroup.Id groupId;
        @Column(id=3)
        protected Timestamp addedOn;

        protected Key() {
            this.accountId = new Account.Id();
            this.groupId = new AccountGroup.Id();
        }

        public Key(Account.Id a, AccountGroup.Id g, Timestamp t) {
            this.accountId = a;
            this.groupId = g;
            this.addedOn = t;
        }

        @Override
        public Account.Id getParentKey() {
            return this.accountId;
        }

        public AccountGroup.Id getGroupId() {
            return this.groupId;
        }

        public Timestamp getAddedOn() {
            return this.addedOn;
        }

        @Override
        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.groupId};
        }
    }
}

