/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibModuleLoader {
    private static final Logger log = LoggerFactory.getLogger(LibModuleLoader.class);

    public static List<Module> loadModules(Injector parent) {
        Config cfg = LibModuleLoader.getConfig(parent);
        return Arrays.stream(cfg.getStringList("gerrit", null, "installModule")).map(m -> LibModuleLoader.createModule(parent, m)).collect(Collectors.toList());
    }

    private static Config getConfig(Injector i) {
        return i.getInstance(Key.get(Config.class, GerritServerConfig.class));
    }

    private static Module createModule(Injector injector, String className) {
        Module m = injector.getInstance(LibModuleLoader.loadModule(className));
        log.info("Installed module {}", (Object)className);
        return m;
    }

    private static Class<Module> loadModule(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | LinkageError e) {
            String msg = "Cannot load LibModule " + className;
            log.error(msg, e);
            throw new ProvisionException(msg, e);
        }
    }
}

