/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.access;

import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.project.GetAccess;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

public class ListAccess
implements RestReadView<TopLevelResource> {
    @Option(name="--project", aliases={"-p"}, metaVar="PROJECT", usage="projects for which the access rights should be returned")
    private List<String> projects = new ArrayList<String>();
    private final GetAccess getAccess;

    @Inject
    public ListAccess(GetAccess getAccess) {
        this.getAccess = getAccess;
    }

    public Map<String, ProjectAccessInfo> apply(TopLevelResource resource) throws ResourceNotFoundException, ResourceConflictException, IOException {
        TreeMap<String, ProjectAccessInfo> access = new TreeMap<String, ProjectAccessInfo>();
        for (String p : this.projects) {
            Project.NameKey projectName = new Project.NameKey(p);
            access.put(p, this.getAccess.apply(projectName));
        }
        return access;
    }
}

