/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.GeneralPreferencesLoader;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.index.account.AccountIndexer;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccountCacheImpl
implements AccountCache {
    private static final Logger log = LoggerFactory.getLogger(AccountCacheImpl.class);
    private static final String BYID_NAME = "accounts";
    private static final String BYUSER_NAME = "accounts_byname";
    private final LoadingCache<Account.Id, Optional<AccountState>> byId;
    private final LoadingCache<String, Optional<Account.Id>> byName;
    private final Provider<AccountIndexer> indexer;

    public static Module module(final boolean useReviewdb) {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(AccountCacheImpl.BYID_NAME, Account.Id.class, new TypeLiteral<Optional<AccountState>>(){}).loader(ByIdLoader.class);
                this.cache(AccountCacheImpl.BYUSER_NAME, String.class, new TypeLiteral<Optional<Account.Id>>(){}).loader(useReviewdb ? ByNameReviewDbLoader.class : ByNameLoader.class);
                this.bind(AccountCacheImpl.class);
                this.bind(AccountCache.class).to(AccountCacheImpl.class);
            }
        };
    }

    @Inject
    AccountCacheImpl(@Named(value="accounts") LoadingCache<Account.Id, Optional<AccountState>> byId, @Named(value="accounts_byname") LoadingCache<String, Optional<Account.Id>> byUsername, Provider<AccountIndexer> indexer) {
        this.byId = byId;
        this.byName = byUsername;
        this.indexer = indexer;
    }

    @Override
    public AccountState get(Account.Id accountId) {
        try {
            return this.byId.get(accountId).orElse(AccountCacheImpl.missing(accountId));
        }
        catch (ExecutionException e) {
            log.warn("Cannot load AccountState for " + accountId, e);
            return AccountCacheImpl.missing(accountId);
        }
    }

    @Override
    @Nullable
    public AccountState getOrNull(Account.Id accountId) {
        try {
            return this.byId.get(accountId).orElse(null);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load AccountState for " + accountId, e);
            return null;
        }
    }

    @Override
    public AccountState getIfPresent(Account.Id accountId) {
        Optional state = (Optional)this.byId.getIfPresent(accountId);
        return state != null ? state.orElse(AccountCacheImpl.missing(accountId)) : null;
    }

    @Override
    public AccountState getByUsername(String username) {
        try {
            Optional<Account.Id> id = this.byName.get(username);
            return id != null && id.isPresent() ? this.getOrNull(id.get()) : null;
        }
        catch (ExecutionException e) {
            log.warn("Cannot load AccountState for " + username, e);
            return null;
        }
    }

    @Override
    public void evict(Account.Id accountId) throws IOException {
        if (accountId != null) {
            this.byId.invalidate(accountId);
            this.indexer.get().index(accountId);
        }
    }

    @Override
    public void evictAll() throws IOException {
        this.byId.invalidateAll();
        for (Account.Id accountId : this.byId.asMap().keySet()) {
            this.indexer.get().index(accountId);
        }
    }

    @Override
    public void evictByUsername(String username) {
        if (username != null) {
            this.byName.invalidate(username);
        }
    }

    private static AccountState missing(Account.Id accountId) {
        Account account = new Account(accountId, TimeUtil.nowTs());
        account.setActive(false);
        ImmutableSet<AccountGroup.UUID> anon = ImmutableSet.of();
        return new AccountState(account, anon, Collections.emptySet(), new HashMap<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>>());
    }

    static class ByNameLoader
    extends CacheLoader<String, Optional<Account.Id>> {
        private final Provider<InternalAccountQuery> accountQueryProvider;

        @Inject
        ByNameLoader(Provider<InternalAccountQuery> accountQueryProvider) {
            this.accountQueryProvider = accountQueryProvider;
        }

        @Override
        public Optional<Account.Id> load(String username) throws Exception {
            AccountState accountState = this.accountQueryProvider.get().oneByExternalId("username", username);
            return Optional.ofNullable(accountState).map(s -> s.getAccount().getId());
        }
    }

    static class ByNameReviewDbLoader
    extends CacheLoader<String, Optional<Account.Id>> {
        private final SchemaFactory<ReviewDb> dbProvider;

        @Inject
        public ByNameReviewDbLoader(SchemaFactory<ReviewDb> dbProvider) {
            this.dbProvider = dbProvider;
        }

        @Override
        public Optional<Account.Id> load(String username) throws Exception {
            try (ReviewDb db = this.dbProvider.open();){
                Optional<Account.Id> optional = Optional.ofNullable(db.accountExternalIds().get(new AccountExternalId.Key("username:" + username))).map(AccountExternalId::getAccountId);
                return optional;
            }
        }
    }

    static class ByIdLoader
    extends CacheLoader<Account.Id, Optional<AccountState>> {
        private final SchemaFactory<ReviewDb> schema;
        private final GroupCache groupCache;
        private final GeneralPreferencesLoader loader;
        private final LoadingCache<String, Optional<Account.Id>> byName;
        private final Provider<WatchConfig.Accessor> watchConfig;

        @Inject
        ByIdLoader(SchemaFactory<ReviewDb> sf, GroupCache groupCache, GeneralPreferencesLoader loader, @Named(value="accounts_byname") LoadingCache<String, Optional<Account.Id>> byUsername, Provider<WatchConfig.Accessor> watchConfig) {
            this.schema = sf;
            this.groupCache = groupCache;
            this.loader = loader;
            this.byName = byUsername;
            this.watchConfig = watchConfig;
        }

        @Override
        public Optional<AccountState> load(Account.Id key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                Optional<AccountState> state = this.load(db, key);
                if (!state.isPresent()) {
                    Optional<AccountState> optional = state;
                    return optional;
                }
                String user = state.get().getUserName();
                if (user != null) {
                    this.byName.put(user, Optional.of(state.get().getAccount().getId()));
                }
                Optional<AccountState> optional = state;
                return optional;
            }
        }

        private Optional<AccountState> load(ReviewDb db, Account.Id who) throws OrmException, IOException, ConfigInvalidException {
            Account account = db.accounts().get(who);
            if (account == null) {
                return Optional.empty();
            }
            Set<ExternalId> externalIds = ExternalId.from(db.accountExternalIds().byAccount(who).toList());
            Set<AccountGroup.UUID> internalGroups = new HashSet();
            for (AccountGroupMember g : db.accountGroupMembers().byAccount(who)) {
                AccountGroup.Id groupId = g.getAccountGroupId();
                AccountGroup group = this.groupCache.get(groupId);
                if (group == null || group.getGroupUUID() == null) continue;
                internalGroups.add(group.getGroupUUID());
            }
            internalGroups = Collections.unmodifiableSet(internalGroups);
            try {
                account.setGeneralPreferences(this.loader.load(who));
            }
            catch (IOException | ConfigInvalidException e) {
                log.warn("Cannot load GeneralPreferences for " + who + " (using default)", e);
                account.setGeneralPreferences(GeneralPreferencesInfo.defaults());
            }
            return Optional.of(new AccountState(account, internalGroups, externalIds, this.watchConfig.get().getProjectWatches(who)));
        }
    }
}

