/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.accounts.EmailInput;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.extensions.common.EmailInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.PutPreferred;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.gerrit.server.mail.send.RegisterNewEmailSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateEmail
implements RestModifyView<AccountResource, EmailInput> {
    private static final Logger log = LoggerFactory.getLogger(CreateEmail.class);
    private final Provider<CurrentUser> self;
    private final Realm realm;
    private final AccountManager accountManager;
    private final RegisterNewEmailSender.Factory registerNewEmailFactory;
    private final PutPreferred putPreferred;
    private final String email;
    private final boolean isDevMode;

    @Inject
    CreateEmail(Provider<CurrentUser> self, Realm realm, AuthConfig authConfig, AccountManager accountManager, RegisterNewEmailSender.Factory registerNewEmailFactory, PutPreferred putPreferred, @Assisted String email) {
        this.self = self;
        this.realm = realm;
        this.accountManager = accountManager;
        this.registerNewEmailFactory = registerNewEmailFactory;
        this.putPreferred = putPreferred;
        this.email = email != null ? email.trim() : null;
        this.isDevMode = authConfig.getAuthType() == AuthType.DEVELOPMENT_BECOME_ANY_ACCOUNT;
    }

    public Response<EmailInfo> apply(AccountResource rsrc, EmailInput input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, OrmException, EmailException, MethodNotAllowedException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to add email address");
        }
        if (input == null) {
            input = new EmailInput();
        }
        if (input.noConfirmation && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to use no_confirmation");
        }
        if (!this.realm.allowsEdit(AccountFieldName.REGISTER_NEW_EMAIL)) {
            throw new MethodNotAllowedException("realm does not allow adding emails");
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<EmailInfo> apply(IdentifiedUser user, EmailInput input) throws AuthException, BadRequestException, ResourceConflictException, ResourceNotFoundException, OrmException, EmailException, MethodNotAllowedException, IOException {
        if (input == null) {
            input = new EmailInput();
        }
        if (input.email != null && !this.email.equals(input.email)) {
            throw new BadRequestException("email address must match URL");
        }
        if (!OutgoingEmailValidator.isValid(this.email)) {
            throw new BadRequestException("invalid email address");
        }
        EmailInfo info = new EmailInfo();
        info.email = this.email;
        if (input.noConfirmation || this.isDevMode) {
            if (this.isDevMode) {
                log.warn("skipping email validation in developer mode");
            }
            try {
                this.accountManager.link(user.getAccountId(), AuthRequest.forEmail(this.email));
            }
            catch (AccountException e) {
                throw new ResourceConflictException(e.getMessage());
            }
            if (input.preferred) {
                this.putPreferred.apply(new AccountResource.Email(user, this.email), null);
                info.preferred = true;
            }
        } else {
            try {
                RegisterNewEmailSender sender = this.registerNewEmailFactory.create(this.email);
                if (!sender.isAllowed()) {
                    throw new MethodNotAllowedException("Not allowed to add email address " + this.email);
                }
                sender.send();
                info.pendingConfirmation = true;
            }
            catch (EmailException | RuntimeException e) {
                log.error("Cannot send email verification message to " + this.email, e);
                throw e;
            }
        }
        return Response.created(info);
    }

    public static interface Factory {
        public CreateEmail create(String var1);
    }
}

