/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.FixInput;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;

public class Check
implements RestReadView<ChangeResource>,
RestModifyView<ChangeResource, FixInput> {
    private final ChangeJson.Factory jsonFactory;

    @Inject
    Check(ChangeJson.Factory json) {
        this.jsonFactory = json;
    }

    public Response<ChangeInfo> apply(ChangeResource rsrc) throws RestApiException, OrmException {
        return Response.withMustRevalidate(this.newChangeJson().format(rsrc));
    }

    public Response<ChangeInfo> apply(ChangeResource rsrc, FixInput input) throws RestApiException, OrmException {
        ChangeControl ctl = rsrc.getControl();
        if (!(ctl.isOwner() || ctl.getProjectControl().isOwner() || ctl.getUser().getCapabilities().canMaintainServer())) {
            throw new AuthException("Cannot fix change");
        }
        return Response.withMustRevalidate(this.newChangeJson().fix(input).format(rsrc));
    }

    private ChangeJson newChangeJson() {
        return this.jsonFactory.create(ListChangesOption.CHECK, new ListChangesOption[0]);
    }
}

