/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.AssigneeChanged;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class DeleteAssignee
implements RestModifyView<ChangeResource, Input> {
    private final BatchUpdate.Factory batchUpdateFactory;
    private final ChangeMessagesUtil cmUtil;
    private final Provider<ReviewDb> db;
    private final AssigneeChanged assigneeChanged;
    private final IdentifiedUser.GenericFactory userFactory;
    private final AccountLoader.Factory accountLoaderFactory;

    @Inject
    DeleteAssignee(BatchUpdate.Factory batchUpdateFactory, ChangeMessagesUtil cmUtil, Provider<ReviewDb> db, AssigneeChanged assigneeChanged, IdentifiedUser.GenericFactory userFactory, AccountLoader.Factory accountLoaderFactory) {
        this.batchUpdateFactory = batchUpdateFactory;
        this.cmUtil = cmUtil;
        this.db = db;
        this.assigneeChanged = assigneeChanged;
        this.userFactory = userFactory;
        this.accountLoaderFactory = accountLoaderFactory;
    }

    public Response<AccountInfo> apply(ChangeResource rsrc, Input input) throws RestApiException, UpdateException, OrmException {
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Op op = new Op();
            bu.addOp(rsrc.getChange().getId(), op);
            bu.execute();
            Account.Id deletedAssignee = op.getDeletedAssignee();
            Response<AccountInfo> response = deletedAssignee == null ? Response.none() : Response.ok(this.accountLoaderFactory.create(true).fillOne(deletedAssignee));
            return response;
        }
    }

    private class Op
    implements BatchUpdateOp {
        private Change change;
        private Account deletedAssignee;

        private Op() {
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException {
            if (!ctx.getControl().canEditAssignee()) {
                throw new AuthException("Delete Assignee not permitted");
            }
            this.change = ctx.getChange();
            ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
            Account.Id currentAssigneeId = this.change.getAssignee();
            if (currentAssigneeId == null) {
                return false;
            }
            IdentifiedUser deletedAssigneeUser = DeleteAssignee.this.userFactory.create(currentAssigneeId);
            this.deletedAssignee = deletedAssigneeUser.getAccount();
            update.removeAssignee();
            this.change.setAssignee(null);
            this.addMessage(ctx, update, deletedAssigneeUser);
            return true;
        }

        public Account.Id getDeletedAssignee() {
            return this.deletedAssignee != null ? this.deletedAssignee.getId() : null;
        }

        private void addMessage(ChangeContext ctx, ChangeUpdate update, IdentifiedUser deletedAssignee) throws OrmException {
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, "Assignee deleted: " + deletedAssignee.getNameEmail(), "autogenerated:gerrit:deleteAssignee");
            DeleteAssignee.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
        }

        @Override
        public void postUpdate(Context ctx) throws OrmException {
            DeleteAssignee.this.assigneeChanged.fire(this.change, ctx.getAccount(), this.deletedAssignee, ctx.getWhen());
        }
    }

    public static class Input {
    }
}

