/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.change.DeleteChangeOp;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.ReceiveCommand;

@Singleton
public class DeleteDraftPatchSet
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private final Provider<ReviewDb> db;
    private final BatchUpdate.Factory updateFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final Provider<DeleteChangeOp> deleteChangeOpProvider;
    private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;
    private final boolean allowDrafts;

    @Inject
    public DeleteDraftPatchSet(Provider<ReviewDb> db, BatchUpdate.Factory updateFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, Provider<DeleteChangeOp> deleteChangeOpProvider, DynamicItem<AccountPatchReviewStore> accountPatchReviewStore, @GerritServerConfig Config cfg) {
        this.db = db;
        this.updateFactory = updateFactory;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.psUtil = psUtil;
        this.deleteChangeOpProvider = deleteChangeOpProvider;
        this.accountPatchReviewStore = accountPatchReviewStore;
        this.allowDrafts = cfg.getBoolean("change", "allowDrafts", true);
    }

    public Response<?> apply(RevisionResource rsrc, Input input) throws RestApiException, UpdateException {
        try (BatchUpdate bu = this.updateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            bu.setOrder(Order.DB_BEFORE_REPO);
            bu.addOp(rsrc.getChange().getId(), new Op(rsrc.getPatchSet().getId()));
            bu.execute();
        }
        return Response.none();
    }

    @Override
    public UiAction.Description getDescription(RevisionResource rsrc) {
        try {
            int psCount = this.psUtil.byChange(this.db.get(), rsrc.getNotes()).size();
            return new UiAction.Description().setLabel("Delete").setTitle(String.format("Delete draft revision %d", rsrc.getPatchSet().getPatchSetId())).setVisible(this.allowDrafts && rsrc.getPatchSet().isDraft() && rsrc.getControl().canDelete(this.db.get(), Change.Status.DRAFT) && psCount > 1);
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    }

    private class Op
    implements BatchUpdateOp {
        private final PatchSet.Id psId;
        private Collection<PatchSet> patchSetsBeforeDeletion;
        private PatchSet patchSet;
        private DeleteChangeOp deleteChangeOp;

        private Op(PatchSet.Id psId) {
            this.psId = psId;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException, NoSuchChangeException {
            ImmutableMap<PatchSet.Id, PatchSet> patchSets = DeleteDraftPatchSet.this.psUtil.byChangeAsMap((ReviewDb)DeleteDraftPatchSet.this.db.get(), ctx.getNotes());
            this.patchSet = (PatchSet)patchSets.get(this.psId);
            if (this.patchSet == null) {
                return false;
            }
            if (!this.patchSet.isDraft()) {
                throw new ResourceConflictException("Patch set is not a draft");
            }
            if (!DeleteDraftPatchSet.this.allowDrafts) {
                throw new MethodNotAllowedException("Draft workflow is disabled");
            }
            if (!ctx.getControl().canDelete(ctx.getDb(), Change.Status.DRAFT)) {
                throw new AuthException("Not permitted to delete this draft patch set");
            }
            this.patchSetsBeforeDeletion = patchSets.values();
            this.deleteDraftPatchSet(this.patchSet, ctx);
            this.deleteOrUpdateDraftChange(ctx, patchSets);
            return true;
        }

        @Override
        public void updateRepo(RepoContext ctx) throws IOException {
            if (this.deleteChangeOp != null) {
                this.deleteChangeOp.updateRepo(ctx);
                return;
            }
            ctx.addRefUpdate(new ReceiveCommand(ObjectId.fromString(this.patchSet.getRevision().get()), ObjectId.zeroId(), this.patchSet.getRefName()));
        }

        private void deleteDraftPatchSet(PatchSet patchSet, ChangeContext ctx) throws OrmException {
            DeleteDraftPatchSet.this.psUtil.delete(ctx.getDb(), ctx.getUpdate(patchSet.getId()), patchSet);
            ((AccountPatchReviewStore)DeleteDraftPatchSet.this.accountPatchReviewStore.get()).clearReviewed(this.psId);
            ReviewDb db = DeleteChangeOp.unwrap(ctx.getDb());
            db.changeMessages().delete(db.changeMessages().byPatchSet(this.psId));
            db.patchComments().delete(db.patchComments().byPatchSet(this.psId));
            db.patchSetApprovals().delete(db.patchSetApprovals().byPatchSet(this.psId));
        }

        private void deleteOrUpdateDraftChange(ChangeContext ctx, Map<PatchSet.Id, PatchSet> patchSets) throws OrmException, RestApiException, IOException, NoSuchChangeException {
            Change c = ctx.getChange();
            if (this.deletedOnlyPatchSet()) {
                this.deleteChangeOp = (DeleteChangeOp)DeleteDraftPatchSet.this.deleteChangeOpProvider.get();
                this.deleteChangeOp.updateChange(ctx);
                return;
            }
            if (c.currentPatchSetId().equals(this.psId)) {
                c.setCurrentPatchSet(this.previousPatchSetInfo(ctx, patchSets));
            }
        }

        private boolean deletedOnlyPatchSet() {
            return this.patchSetsBeforeDeletion.size() == 1 && this.patchSetsBeforeDeletion.iterator().next().getId().equals(this.psId);
        }

        private PatchSetInfo previousPatchSetInfo(ChangeContext ctx, Map<PatchSet.Id, PatchSet> patchSets) throws OrmException {
            PatchSet.Id prevPsId = null;
            for (PatchSet.Id id : patchSets.keySet()) {
                if (id.get() >= this.psId.get() || prevPsId != null && id.get() <= prevPsId.get()) continue;
                prevPsId = id;
            }
            try {
                return DeleteDraftPatchSet.this.patchSetInfoFactory.get(ctx.getDb(), ctx.getNotes(), new PatchSet.Id(this.psId.getParentKey(), Preconditions.checkNotNull(prevPsId).get()));
            }
            catch (PatchSetInfoNotAvailableException e) {
                throw new OrmException(e);
            }
        }
    }

    public static class Input {
    }
}

