/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.extensions.events.DraftPublished;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.send.CreateChangeSender;
import com.google.gerrit.server.mail.send.ReplacePatchSetSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PublishDraftPatchSet
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(PublishDraftPatchSet.class);
    private final AccountResolver accountResolver;
    private final ApprovalsUtil approvalsUtil;
    private final BatchUpdate.Factory updateFactory;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final Provider<ReviewDb> dbProvider;
    private final ReplacePatchSetSender.Factory replacePatchSetFactory;
    private final DraftPublished draftPublished;

    @Inject
    public PublishDraftPatchSet(AccountResolver accountResolver, ApprovalsUtil approvalsUtil, BatchUpdate.Factory updateFactory, CreateChangeSender.Factory createChangeSenderFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, Provider<ReviewDb> dbProvider, ReplacePatchSetSender.Factory replacePatchSetFactory, DraftPublished draftPublished) {
        this.accountResolver = accountResolver;
        this.approvalsUtil = approvalsUtil;
        this.updateFactory = updateFactory;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.psUtil = psUtil;
        this.dbProvider = dbProvider;
        this.replacePatchSetFactory = replacePatchSetFactory;
        this.draftPublished = draftPublished;
    }

    public Response<?> apply(RevisionResource rsrc, Input input) throws RestApiException, UpdateException {
        return this.apply(rsrc.getUser(), rsrc.getChange(), rsrc.getPatchSet().getId(), rsrc.getPatchSet());
    }

    private Response<?> apply(CurrentUser u, Change c, PatchSet.Id psId, PatchSet ps) throws RestApiException, UpdateException {
        try (BatchUpdate bu = this.updateFactory.create(this.dbProvider.get(), c.getProject(), u, TimeUtil.nowTs());){
            bu.addOp(c.getId(), new Op(psId, ps));
            bu.execute();
        }
        return Response.none();
    }

    @Override
    public UiAction.Description getDescription(RevisionResource rsrc) {
        try {
            return new UiAction.Description().setLabel("Publish").setTitle(String.format("Publish revision %d", rsrc.getPatchSet().getPatchSetId())).setVisible(rsrc.getPatchSet().isDraft() && rsrc.getControl().canPublish(this.dbProvider.get()));
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    }

    private class Op
    implements BatchUpdateOp {
        private final PatchSet.Id psId;
        private PatchSet patchSet;
        private Change change;
        private boolean wasDraftChange;
        private PatchSetInfo patchSetInfo;
        private MailUtil.MailRecipients recipients;

        private Op(@Nullable PatchSet.Id psId, PatchSet patchSet) {
            this.psId = psId;
            this.patchSet = patchSet;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException {
            if (!ctx.getControl().canPublish(ctx.getDb())) {
                throw new AuthException("Cannot publish this draft patch set");
            }
            if (this.patchSet == null) {
                this.patchSet = PublishDraftPatchSet.this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.psId);
                if (this.patchSet == null) {
                    throw new ResourceNotFoundException(this.psId.toString());
                }
            }
            this.saveChange(ctx);
            this.savePatchSet(ctx);
            this.addReviewers(ctx);
            return true;
        }

        private void saveChange(ChangeContext ctx) {
            this.change = ctx.getChange();
            ChangeUpdate update = ctx.getUpdate(this.psId);
            boolean bl = this.wasDraftChange = this.change.getStatus() == Change.Status.DRAFT;
            if (this.wasDraftChange) {
                this.change.setStatus(Change.Status.NEW);
                update.setStatus(this.change.getStatus());
            }
        }

        private void savePatchSet(ChangeContext ctx) throws RestApiException, OrmException {
            if (!this.patchSet.isDraft()) {
                throw new ResourceConflictException("Patch set is not a draft");
            }
            PublishDraftPatchSet.this.psUtil.publish(ctx.getDb(), ctx.getUpdate(this.psId), this.patchSet);
        }

        private void addReviewers(ChangeContext ctx) throws OrmException, IOException {
            LabelTypes labelTypes = ctx.getControl().getLabelTypes();
            ImmutableSet<Account.Id> oldReviewers = PublishDraftPatchSet.this.approvalsUtil.getReviewers(ctx.getDb(), ctx.getNotes()).all();
            RevCommit commit = ctx.getRevWalk().parseCommit(ObjectId.fromString(this.patchSet.getRevision().get()));
            this.patchSetInfo = PublishDraftPatchSet.this.patchSetInfoFactory.get(ctx.getRevWalk(), commit, this.psId);
            List<FooterLine> footerLines = commit.getFooterLines();
            this.recipients = MailUtil.getRecipientsFromFooters(ctx.getDb(), PublishDraftPatchSet.this.accountResolver, this.patchSet.isDraft(), footerLines);
            this.recipients.remove(ctx.getAccountId());
            PublishDraftPatchSet.this.approvalsUtil.addReviewers(ctx.getDb(), ctx.getUpdate(this.psId), labelTypes, this.change, this.patchSet, this.patchSetInfo, this.recipients.getReviewers(), oldReviewers);
        }

        @Override
        public void postUpdate(Context ctx) throws OrmException {
            PublishDraftPatchSet.this.draftPublished.fire(this.change, this.patchSet, ctx.getAccount(), ctx.getWhen());
            if (this.patchSet.isDraft() && this.change.getStatus() == Change.Status.DRAFT) {
                return;
            }
            try {
                if (this.wasDraftChange) {
                    this.sendCreateChange(ctx);
                } else {
                    this.sendReplacePatchSet(ctx);
                }
            }
            catch (EmailException e) {
                log.error("Cannot send email for publishing draft " + this.psId, e);
            }
        }

        private void sendCreateChange(Context ctx) throws EmailException {
            CreateChangeSender cm = PublishDraftPatchSet.this.createChangeSenderFactory.create(ctx.getProject(), this.change.getId());
            cm.setFrom(ctx.getAccountId());
            cm.setPatchSet(this.patchSet, this.patchSetInfo);
            cm.addReviewers(this.recipients.getReviewers());
            cm.addExtraCC(this.recipients.getCcOnly());
            cm.send();
        }

        private void sendReplacePatchSet(Context ctx) throws EmailException {
            ChangeMessage msg = ChangeMessagesUtil.newMessage(this.psId, ctx.getUser(), ctx.getWhen(), "Uploaded patch set " + this.psId.get() + ".", "autogenerated:gerrit:newPatchSet");
            ReplacePatchSetSender cm = PublishDraftPatchSet.this.replacePatchSetFactory.create(ctx.getProject(), this.change.getId());
            cm.setFrom(ctx.getAccountId());
            cm.setPatchSet(this.patchSet, this.patchSetInfo);
            cm.setChangeMessage(msg.getMessage(), ctx.getWhen());
            cm.addReviewers(this.recipients.getReviewers());
            cm.addExtraCC(this.recipients.getCcOnly());
            cm.send();
        }
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, Input> {
        private final PublishDraftPatchSet publish;

        @Inject
        CurrentRevision(PublishDraftPatchSet publish) {
            this.publish = publish;
        }

        public Response<?> apply(ChangeResource rsrc, Input input) throws RestApiException, UpdateException {
            return this.publish.apply(rsrc.getControl().getUser(), rsrc.getChange(), rsrc.getChange().currentPatchSetId(), null);
        }
    }

    public static class Input {
    }
}

