/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.extensions.client.GitBasicAuthPolicy;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.auth.openid.OpenIdProviderPattern;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtjsonrpc.server.SignedToken;
import com.google.gwtjsonrpc.server.XsrfException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class AuthConfig {
    private final AuthType authType;
    private final String httpHeader;
    private final String httpDisplaynameHeader;
    private final String httpEmailHeader;
    private final String httpExternalIdHeader;
    private final String registerPageUrl;
    private final String registerUrl;
    private final String registerText;
    private final boolean trustContainerAuth;
    private final boolean enableRunAs;
    private final boolean userNameToLowerCase;
    private final boolean useContributorAgreements;
    private final String loginUrl;
    private final String loginText;
    private final String logoutUrl;
    private final String switchAccountUrl;
    private final String editFullNameUrl;
    private final String httpPasswordUrl;
    private final String openIdSsoUrl;
    private final List<String> openIdDomains;
    private final List<OpenIdProviderPattern> trustedOpenIDs;
    private final List<OpenIdProviderPattern> allowedOpenIDs;
    private final String cookiePath;
    private final String cookieDomain;
    private final boolean cookieSecure;
    private final SignedToken emailReg;
    private final boolean allowRegisterNewEmail;
    private GitBasicAuthPolicy gitBasicAuthPolicy;

    @Inject
    AuthConfig(@GerritServerConfig Config cfg) throws XsrfException {
        this.authType = AuthConfig.toType(cfg);
        this.httpHeader = cfg.getString("auth", null, "httpheader");
        this.httpDisplaynameHeader = cfg.getString("auth", null, "httpdisplaynameheader");
        this.httpEmailHeader = cfg.getString("auth", null, "httpemailheader");
        this.httpExternalIdHeader = cfg.getString("auth", null, "httpexternalidheader");
        this.loginUrl = cfg.getString("auth", null, "loginurl");
        this.loginText = cfg.getString("auth", null, "logintext");
        this.logoutUrl = cfg.getString("auth", null, "logouturl");
        this.switchAccountUrl = cfg.getString("auth", null, "switchAccountUrl");
        this.editFullNameUrl = cfg.getString("auth", null, "editFullNameUrl");
        this.httpPasswordUrl = cfg.getString("auth", null, "httpPasswordUrl");
        this.registerPageUrl = cfg.getString("auth", null, "registerPageUrl");
        this.registerUrl = cfg.getString("auth", null, "registerUrl");
        this.registerText = cfg.getString("auth", null, "registerText");
        this.openIdSsoUrl = cfg.getString("auth", null, "openidssourl");
        this.openIdDomains = Arrays.asList(cfg.getStringList("auth", null, "openIdDomain"));
        this.trustedOpenIDs = AuthConfig.toPatterns(cfg, "trustedOpenID");
        this.allowedOpenIDs = AuthConfig.toPatterns(cfg, "allowedOpenID");
        this.cookiePath = cfg.getString("auth", null, "cookiepath");
        this.cookieDomain = cfg.getString("auth", null, "cookiedomain");
        this.cookieSecure = cfg.getBoolean("auth", "cookiesecure", false);
        this.trustContainerAuth = cfg.getBoolean("auth", "trustContainerAuth", false);
        this.enableRunAs = cfg.getBoolean("auth", null, "enableRunAs", true);
        this.gitBasicAuthPolicy = this.getBasicAuthPolicy(cfg);
        this.useContributorAgreements = cfg.getBoolean("auth", "contributoragreements", false);
        this.userNameToLowerCase = cfg.getBoolean("auth", "userNameToLowerCase", false);
        this.allowRegisterNewEmail = cfg.getBoolean("auth", "allowRegisterNewEmail", true);
        if (this.gitBasicAuthPolicy == GitBasicAuthPolicy.HTTP_LDAP && this.authType != AuthType.LDAP && this.authType != AuthType.LDAP_BIND) {
            throw new IllegalStateException("use auth.gitBasicAuthPolicy HTTP_LDAP only with auth.type LDAP or LDAP_BIND");
        }
        if (this.gitBasicAuthPolicy == GitBasicAuthPolicy.OAUTH && this.authType != AuthType.OAUTH) {
            throw new IllegalStateException("use auth.gitBasicAuthPolicy OAUTH only with auth.type OAUTH");
        }
        String key = cfg.getString("auth", null, "registerEmailPrivateKey");
        if (key != null && !key.isEmpty()) {
            int age = (int)ConfigUtil.getTimeUnit(cfg, "auth", null, "maxRegisterEmailTokenAge", TimeUnit.SECONDS.convert(12L, TimeUnit.HOURS), TimeUnit.SECONDS);
            this.emailReg = new SignedToken(age, key);
        } else {
            this.emailReg = null;
        }
    }

    private static List<OpenIdProviderPattern> toPatterns(Config cfg, String name) {
        String[] s = cfg.getStringList("auth", null, name);
        if (s.length == 0) {
            s = new String[]{"http://", "https://"};
        }
        ArrayList<OpenIdProviderPattern> r = new ArrayList<OpenIdProviderPattern>();
        for (String pattern : s) {
            r.add(OpenIdProviderPattern.create(pattern));
        }
        return Collections.unmodifiableList(r);
    }

    private static AuthType toType(Config cfg) {
        return cfg.getEnum("auth", null, "type", AuthType.OPENID);
    }

    private GitBasicAuthPolicy getBasicAuthPolicy(Config cfg) {
        GitBasicAuthPolicy defaultAuthPolicy = this.isLdapAuthType() ? GitBasicAuthPolicy.LDAP : (this.isOAuthType() ? GitBasicAuthPolicy.OAUTH : GitBasicAuthPolicy.HTTP);
        return cfg.getEnum("auth", null, "gitBasicAuthPolicy", defaultAuthPolicy);
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getLoginHttpHeader() {
        return this.httpHeader;
    }

    public String getHttpDisplaynameHeader() {
        return this.httpDisplaynameHeader;
    }

    public String getHttpEmailHeader() {
        return this.httpEmailHeader;
    }

    public String getHttpExternalIdHeader() {
        return this.httpExternalIdHeader;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLoginText() {
        return this.loginText;
    }

    public String getLogoutURL() {
        return this.logoutUrl;
    }

    public String getSwitchAccountUrl() {
        return this.switchAccountUrl;
    }

    public String getEditFullNameUrl() {
        return this.editFullNameUrl;
    }

    public String getHttpPasswordUrl() {
        return this.httpPasswordUrl;
    }

    public String getOpenIdSsoUrl() {
        return this.openIdSsoUrl;
    }

    public List<String> getOpenIdDomains() {
        return this.openIdDomains;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public boolean getCookieSecure() {
        return this.cookieSecure;
    }

    public SignedToken getEmailRegistrationToken() {
        return this.emailReg;
    }

    public List<OpenIdProviderPattern> getAllowedOpenIDs() {
        return this.allowedOpenIDs;
    }

    public boolean isTrustContainerAuth() {
        return this.trustContainerAuth;
    }

    public boolean isRunAsEnabled() {
        return this.enableRunAs;
    }

    public boolean isUserNameToLowerCase() {
        return this.userNameToLowerCase;
    }

    public GitBasicAuthPolicy getGitBasicAuthPolicy() {
        return this.gitBasicAuthPolicy;
    }

    public boolean isUseContributorAgreements() {
        return this.useContributorAgreements;
    }

    public boolean isIdentityTrustable(Collection<ExternalId> ids) {
        switch (this.getAuthType()) {
            case DEVELOPMENT_BECOME_ANY_ACCOUNT: 
            case HTTP: 
            case HTTP_LDAP: 
            case LDAP: 
            case LDAP_BIND: 
            case CLIENT_SSL_CERT_LDAP: 
            case CUSTOM_EXTENSION: 
            case OAUTH: {
                return true;
            }
            case OPENID_SSO: {
                return true;
            }
            case OPENID: {
                for (ExternalId e : ids) {
                    if (this.isTrusted(e)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isTrusted(ExternalId id) {
        if (id.isScheme("mailto")) {
            return true;
        }
        if (id.isScheme("uuid")) {
            return true;
        }
        if (id.isScheme("username")) {
            return true;
        }
        for (OpenIdProviderPattern p : this.trustedOpenIDs) {
            if (!p.matches(id)) continue;
            return true;
        }
        return false;
    }

    public String getRegisterPageUrl() {
        return this.registerPageUrl;
    }

    public String getRegisterUrl() {
        return this.registerUrl;
    }

    public String getRegisterText() {
        return this.registerText;
    }

    public boolean isLdapAuthType() {
        return this.authType == AuthType.LDAP || this.authType == AuthType.LDAP_BIND;
    }

    public boolean isOAuthType() {
        return this.authType == AuthType.OAUTH;
    }

    public boolean isAllowRegisterNewEmail() {
        return this.allowRegisterNewEmail;
    }
}

