/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GlobalPluginConfig;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.ProjectLevelConfig;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.ReloadPluginListener;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginConfigFactory
implements ReloadPluginListener {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigFactory.class);
    private static final String EXTENSION = ".config";
    private final SitePaths site;
    private final Provider<Config> cfgProvider;
    private final ProjectCache projectCache;
    private final ProjectState.Factory projectStateFactory;
    private final SecureStore secureStore;
    private final Map<String, Config> pluginConfigs;
    private volatile FileSnapshot cfgSnapshot;
    private volatile Config cfg;

    @Inject
    PluginConfigFactory(SitePaths site, @GerritServerConfig Provider<Config> cfgProvider, ProjectCache projectCache, ProjectState.Factory projectStateFactory, SecureStore secureStore) {
        this.site = site;
        this.cfgProvider = cfgProvider;
        this.projectCache = projectCache;
        this.projectStateFactory = projectStateFactory;
        this.secureStore = secureStore;
        this.pluginConfigs = new HashMap<String, Config>();
        this.cfgSnapshot = FileSnapshot.save(site.gerrit_config.toFile());
        this.cfg = cfgProvider.get();
    }

    public PluginConfig getFromGerritConfig(String pluginName) {
        return this.getFromGerritConfig(pluginName, false);
    }

    public PluginConfig getFromGerritConfig(String pluginName, boolean refresh) {
        if (refresh && this.secureStore.isOutdated()) {
            this.secureStore.reload();
        }
        File configFile = this.site.gerrit_config.toFile();
        if (refresh && this.cfgSnapshot.isModified(configFile)) {
            this.cfgSnapshot = FileSnapshot.save(configFile);
            this.cfg = this.cfgProvider.get();
        }
        return new PluginConfig(pluginName, this.cfg);
    }

    public PluginConfig getFromProjectConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        ProjectState projectState = this.projectCache.get(projectName);
        if (projectState == null) {
            throw new NoSuchProjectException(projectName);
        }
        return this.getFromProjectConfig(projectState, pluginName);
    }

    public PluginConfig getFromProjectConfig(ProjectState projectState, String pluginName) {
        return projectState.getConfig().getPluginConfig(pluginName);
    }

    public PluginConfig getFromProjectConfigWithInheritance(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getFromProjectConfig(projectName, pluginName).withInheritance(this.projectStateFactory);
    }

    public PluginConfig getFromProjectConfigWithInheritance(ProjectState projectState, String pluginName) {
        return this.getFromProjectConfig(projectState, pluginName).withInheritance(this.projectStateFactory);
    }

    public synchronized Config getGlobalPluginConfig(String pluginName) {
        if (this.pluginConfigs.containsKey(pluginName)) {
            return this.pluginConfigs.get(pluginName);
        }
        Path pluginConfigFile = this.site.etc_dir.resolve(pluginName + EXTENSION);
        FileBasedConfig cfg = new FileBasedConfig(pluginConfigFile.toFile(), FS.DETECTED);
        GlobalPluginConfig pluginConfig = new GlobalPluginConfig(pluginName, cfg, this.secureStore);
        this.pluginConfigs.put(pluginName, pluginConfig);
        if (!cfg.getFile().exists()) {
            log.info("No " + pluginConfigFile.toAbsolutePath() + "; assuming defaults");
            return pluginConfig;
        }
        try {
            cfg.load();
        }
        catch (ConfigInvalidException e) {
            log.warn("Failed to load " + pluginConfigFile.toAbsolutePath() + ": " + e);
        }
        catch (IOException e) {
            log.warn("Failed to load " + pluginConfigFile.toAbsolutePath(), e);
        }
        return pluginConfig;
    }

    public Config getProjectPluginConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getPluginConfig(projectName, pluginName).get();
    }

    public Config getProjectPluginConfig(ProjectState projectState, String pluginName) {
        return projectState.getConfig(pluginName + EXTENSION).get();
    }

    public Config getProjectPluginConfigWithInheritance(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getPluginConfig(projectName, pluginName).getWithInheritance(false);
    }

    public Config getProjectPluginConfigWithMergedInheritance(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        return this.getPluginConfig(projectName, pluginName).getWithInheritance(true);
    }

    public Config getProjectPluginConfigWithInheritance(ProjectState projectState, String pluginName) {
        return projectState.getConfig(pluginName + EXTENSION).getWithInheritance(false);
    }

    public Config getProjectPluginConfigWithMergedInheritance(ProjectState projectState, String pluginName) {
        return projectState.getConfig(pluginName + EXTENSION).getWithInheritance(true);
    }

    private ProjectLevelConfig getPluginConfig(Project.NameKey projectName, String pluginName) throws NoSuchProjectException {
        ProjectState projectState = this.projectCache.get(projectName);
        if (projectState == null) {
            throw new NoSuchProjectException(projectName);
        }
        return projectState.getConfig(pluginName + EXTENSION);
    }

    @Override
    public synchronized void onReloadPlugin(Plugin oldPlugin, Plugin newPlugin) {
        this.pluginConfigs.remove(oldPlugin.getName());
    }
}

