/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.EventTypes;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class EventDeserializer
implements JsonDeserializer<Event> {
    @Override
    public Event deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Not an object");
        }
        JsonElement typeJson = json.getAsJsonObject().get("type");
        if (typeJson == null || !typeJson.isJsonPrimitive() || !typeJson.getAsJsonPrimitive().isString()) {
            throw new JsonParseException("Type is not a string: " + typeJson);
        }
        String type = typeJson.getAsJsonPrimitive().getAsString();
        Class<?> cls = EventTypes.getClass(type);
        if (cls == null) {
            throw new JsonParseException("Unknown event type: " + type);
        }
        return (Event)context.deserialize(json, cls);
    }
}

